/*
 * Decompiled with CFR 0.152.
 */
package EBBU;

import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Sim2
extends AdvancedRobot {
    int count = 0;
    int count2 = 0;
    double power = 3.0;
    int noHit = 0;
    int missed = 0;
    EnemyBot eB = new EnemyBot();

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.eB.heading1 = -1.0;
        this.eB.Name = "";
        while (true) {
            ++this.count;
            ++this.noHit;
            if (this.count > 10) {
                this.setTurnRadarRightRadians(0.7853981633974483);
            }
            if (this.noHit > 3 && this.getDistanceRemaining() > -1.0 && this.getDistanceRemaining() < 1.0) {
                this.setTurnLeftRadians(1.5707963267948966);
                this.setAhead(20.0);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absH = Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians()));
        double vLat = Math.sin(e.getHeadingRadians() - absH) * e.getVelocity();
        if (this.eB.Name == "") {
            this.eB.Name = e.getName();
            this.eB.heading1 = e.getHeadingRadians();
            this.eB.absH1 = absH;
            this.eB.absH2 = absH;
        }
        if (this.eB.Name == e.getName()) {
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absH - this.getRadarHeadingRadians())));
            this.eB.heading2 = this.eB.heading1;
            this.eB.heading1 = e.getHeadingRadians();
            if (this.count2 < 30) {
                if (absH <= this.eB.absH1) {
                    this.eB.absH1 = absH;
                }
                if (absH >= this.eB.absH2) {
                    this.eB.absH2 = absH;
                }
                ++this.count2;
            } else {
                this.eB.absH1 = absH;
                this.eB.absH2 = absH;
                this.count2 = 0;
            }
            if (this.eB.heading2 != this.eB.heading1) {
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.eB.absH1 + (this.eB.absH2 - this.eB.absH1) / 2.0 - this.getGunHeadingRadians())));
                this.setFire(this.power);
            } else {
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absH - this.getGunHeadingRadians() + Math.asin(vLat / (20.0 - 3.0 * this.power)))));
                this.setFire(this.power);
            }
        }
        this.count = 0;
        if (this.missed > 10) {
            this.missed = 0;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double a = e.getBearingRadians();
        if (a > 1.5707963267948966 || a < -1.5707963267948966) {
            this.setAhead(100.0);
            this.setTurnRightRadians(a + 1.5707963267948966);
        } else {
            this.setBack(100.0);
            this.setTurnRightRadians(a + 1.5707963267948966);
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.setBack(20.0);
    }

    public void onHitRobot(HitRobotEvent e) {
        double a = e.getBearingRadians();
        if (a > 1.5707963267948966 || a < -1.5707963267948966) {
            this.setAhead(20.0);
            this.setTurnRightRadians(a + 1.5707963267948966);
        } else {
            this.setBack(20.0);
            this.setTurnRightRadians(a + 1.5707963267948966);
        }
        this.setTurnGunLeftRadians(Utils.normalRelativeAngle((double)(this.getHeadingRadians() + a - this.getGunHeadingRadians())));
        this.setFire(this.power);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++this.missed;
        if (this.missed > 3) {
            this.power *= 0.8;
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        this.missed = 0;
        this.power = 3.0;
        this.noHit = 0;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.eB.Name) {
            this.eB.Name = "";
        }
    }

    private class EnemyBot {
        double heading1;
        double heading2;
        double absH1;
        double absH2;
        String Name;

        private EnemyBot() {
        }
    }
}

