/*
 * Decompiled with CFR 0.152.
 */
package ds.constant;

import java.util.HashMap;

public class ConstantManager {
    private HashMap<String, String> m_stringConstants = new HashMap();
    private HashMap<String, Long> m_integerConstants = new HashMap();
    private HashMap<String, Double> m_doubleConstants = new HashMap();
    private HashMap<String, Boolean> m_booleanConstants = new HashMap();
    private static ConstantManager s_instance = null;

    private ConstantManager() {
        this.loadBuiltIn();
    }

    public static ConstantManager getInstance() {
        if (s_instance == null) {
            s_instance = new ConstantManager();
        }
        return s_instance;
    }

    public void loadFromFile() {
    }

    public void loadBuiltIn() {
        this.registerConstant("debug", false);
        this.registerConstant("debugData", false);
        this.registerConstant("radar.focus", 5L);
        this.registerConstant("gun.selector.statsDepth", 100L);
        this.registerConstant("gun.hot.active", true);
        this.registerConstant("gun.hot.confidence", 0.95);
        this.registerConstant("gun.linear.active", true);
        this.registerConstant("gun.linear.confidence", 0.97);
        this.registerConstant("gun.dsgf.nbSamples", 84L);
        this.registerConstant("gun.dsgfFast.active", false);
        this.registerConstant("gun.dsgfFast.decayFactor", 0.0);
        this.registerConstant("gun.dsgfFast.maxNodeLeafCount", 150L);
        this.registerConstant("gun.dsgfFast.minNodeLeafCount", 50L);
        this.registerConstant("gun.dsgfFast.flood", 2L);
        this.registerConstant("gun.dsgfFast.confidence", 1.0);
        this.registerConstant("gun.dsgfSlow.active", true);
        this.registerConstant("gun.dsgfSlow.decayFactor", 0.0);
        this.registerConstant("gun.dsgfSlow.maxNodeLeafCount", 1000L);
        this.registerConstant("gun.dsgfSlow.minNodeLeafCount", 200L);
        this.registerConstant("gun.dsgfSlow.flood", 10L);
        this.registerConstant("gun.dsgfSlow.confidence", 1.05);
        this.registerConstant("gun.dsgfAWS.active", true);
        this.registerConstant("gun.dsgfAWS.decayFactor", 0.0);
        this.registerConstant("gun.dsgfAWS.maxNodeLeafCount", 300L);
        this.registerConstant("gun.dsgfAWS.minNodeLeafCount", 50L);
        this.registerConstant("gun.dsgfAWS.flood", 0L);
        this.registerConstant("gun.dsgfAWS.confidence", 1.05);
        this.registerConstant("gun.dsgf.maxChildNodeCount", 2L);
        this.registerConstant("gun.dsgf.segmentationFactor", 10L);
        this.registerConstant("gun.dsgf.densityEstimationWindow", 1L);
        this.registerConstant("movement.active", true);
        this.registerConstant("movement.cornerGravity", 10000.0);
        this.registerConstant("movement.cornerGravityType", 2.0);
        this.registerConstant("movement.centerGravity", 1.0);
        this.registerConstant("movement.centerGravityType", 1.0);
        this.registerConstant("movement.targetGravity", 30.0);
        this.registerConstant("movement.targetGravityType", 1.5);
        this.registerConstant("movement.wallsGravity", 10.0);
        this.registerConstant("movement.wallsGravityType", 3.0);
        this.registerConstant("movement.BulletGravity", 0.1);
        this.registerConstant("movement.BulletGravityType", 1.5);
    }

    public void registerConstant(String name, String value) {
        this.m_stringConstants.put(name, value);
    }

    public void registerConstant(String name, long value) {
        this.m_integerConstants.put(name, value);
    }

    public void registerConstant(String name, double value) {
        this.m_doubleConstants.put(name, value);
    }

    public void registerConstant(String name, boolean value) {
        this.m_booleanConstants.put(name, value);
    }

    public String getStringConstant(String name) {
        return this.m_stringConstants.get(name);
    }

    public Long getIntegerConstant(String name) {
        return this.m_integerConstants.get(name);
    }

    public Double getDoubleConstant(String name) {
        return this.m_doubleConstants.get(name);
    }

    public boolean getBooleanConstant(String name) {
        return this.m_booleanConstants.get(name);
    }
}

