/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.bot;

import java.util.Iterator;
import pedersen.debug.Debug;
import pedersen.divination.WaveData;
import pedersen.tactics.bot.BearingOffsetRange;
import pedersen.tactics.bot.BearingOffsetTracker;

public abstract class BearingOffsetTrackerBucketBase
implements BearingOffsetTracker {
    protected static final int fixedBinSize = 50;
    private static final double maximumValue = 0.8726646259971648;
    private static final double valuePerIndex = Math.PI / 180;
    private static final double indexPerValue = 57.29577951308232;
    protected long zero = 0L;
    protected final long[] positive = new long[50];
    protected final long[] negative = new long[50];
    protected long volume = 0L;

    protected BearingOffsetTrackerBucketBase() {
    }

    protected int convertValueToSignedBinWithOffset(double value) {
        int signedBinWithOffset = 0;
        if (value > 0.0) {
            signedBinWithOffset = 1 + Math.min((int)(57.29577951308232 * value), 50);
        }
        if (value < 0.0) {
            signedBinWithOffset = -(1 + Math.min((int)(57.29577951308232 * -value), 50));
        }
        return signedBinWithOffset;
    }

    protected double convertSignedBinWithOffsetToValue(int signedBinWithOffset) {
        double value = 0.0;
        if (signedBinWithOffset > 0) {
            value = Math.PI / 180 * (double)signedBinWithOffset;
        }
        if (signedBinWithOffset < 0) {
            value = Math.PI / 180 * (double)signedBinWithOffset;
        }
        return value;
    }

    public void addWaveData(WaveData waveData) {
        Iterator iterator = waveData.getBearingOffsetRangeIterator();
        while (iterator.hasNext()) {
            this.addRange((BearingOffsetRange)iterator.next());
        }
    }

    private void addRange(BearingOffsetRange bearingOffsetRange) {
        int min = this.convertValueToSignedBinWithOffset(bearingOffsetRange.min());
        int max = this.convertValueToSignedBinWithOffset(bearingOffsetRange.max());
        if (min > 0) {
            int i = min;
            while (i < 50 && i <= max) {
                int n = i - 1;
                this.positive[n] = this.positive[n] + 1L;
                ++this.volume;
                ++i;
            }
        } else if (max < 0) {
            int i = -max;
            while (i < 50 && i <= -min) {
                int n = i - 1;
                this.negative[n] = this.negative[n] + 1L;
                ++this.volume;
                ++i;
            }
        } else {
            ++this.zero;
            ++this.volume;
            int i = 1;
            while (i < 50 && i <= max) {
                int n = i - 1;
                this.positive[n] = this.positive[n] + 1L;
                ++this.volume;
                ++i;
            }
            i = 1;
            while (i < 50 && i <= -min) {
                int n = i - 1;
                this.negative[n] = this.negative[n] + 1L;
                ++this.volume;
                ++i;
            }
        }
    }

    public void onFire() {
    }

    public double getEntropy() {
        double entropy = 0.0;
        if (this.zero != 0L) {
            entropy += this.getEntropy(this.zero);
        }
        int i = 0;
        while (i < 50) {
            if (this.positive[i] != 0L) {
                entropy += this.getEntropy(this.positive[i]);
            }
            if (this.negative[i] != 0L) {
                entropy += this.getEntropy(this.negative[i]);
            }
            ++i;
        }
        return entropy;
    }

    private double getEntropy(double value) {
        double quotient = value / (double)this.volume;
        return -quotient * Math.log(quotient) / Math.log(2.0);
    }

    private double getEntropyMaximum() {
        return Math.log(this.volume) / Math.log(2.0);
    }

    public double getNormalizedEntropy() {
        return this.getEntropy() / this.getEntropyMaximum();
    }

    public void debug() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Visit counts: ");
        buffer.append("[");
        int i = 50;
        while (i > 0) {
            if (i > 0) {
                buffer.append("|");
            }
            if (this.negative[i - 1] > 0L) {
                buffer.append(this.negative[i - 1]);
            }
            --i;
        }
        buffer.append("]");
        buffer.append(" " + this.zero + " ");
        buffer.append("[");
        i = 0;
        while (i < 50) {
            if (i > 0) {
                buffer.append("|");
            }
            if (this.positive[i] > 0L) {
                buffer.append(this.positive[i]);
            }
            ++i;
        }
        buffer.append("]");
        Debug.debug(buffer.toString());
    }
}

