/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.tactics.movement.MovementMethod;
import pedersen.tactics.movement.MovementMethodSetBuilder;

public class MovementMethodSetImpl
implements MovementMethodSetBuilder {
    private final List ambientMovementMethods = new ArrayList();
    private final List dynamicMovementMethods = new ArrayList();

    public MovementMethod getOptimalMovementMethod(int gracePeriod) {
        MovementMethod preferredMovementMethod = null;
        int preferredHitTally = 0;
        double preferredHitRatio = 0.0;
        boolean movementMethodDetermined = false;
        Iterator iterator = this.dynamicMovementMethods.iterator();
        while (!movementMethodDetermined && iterator.hasNext()) {
            double presentHitRatio;
            MovementMethod presentMovementMethod = (MovementMethod)iterator.next();
            int presentHitTally = presentMovementMethod.getHitTally();
            if (preferredMovementMethod == null) {
                preferredMovementMethod = presentMovementMethod;
                preferredHitTally = presentHitTally;
                preferredHitRatio = (double)preferredMovementMethod.getTimeInUse() / (double)preferredHitTally;
                if (preferredHitTally != 0) continue;
                movementMethodDetermined = true;
                continue;
            }
            if (presentHitTally < gracePeriod) {
                if (presentHitTally == preferredHitTally || presentHitTally >= preferredHitTally) continue;
                preferredMovementMethod = presentMovementMethod;
                preferredHitTally = presentHitTally;
                preferredHitRatio = (double)preferredMovementMethod.getTimeInUse() / (double)preferredHitTally;
                movementMethodDetermined = true;
                continue;
            }
            if (preferredHitTally < gracePeriod || !((presentHitRatio = (double)presentMovementMethod.getTimeInUse() / (double)presentHitTally) > preferredHitRatio)) continue;
            preferredMovementMethod = presentMovementMethod;
            preferredHitTally = presentHitTally;
            preferredHitRatio = presentHitRatio;
        }
        return preferredMovementMethod;
    }

    public void debug() {
        Iterator iterator = this.ambientMovementMethods.iterator();
        while (iterator.hasNext()) {
            ((MovementMethod)iterator.next()).debug();
        }
        iterator = this.dynamicMovementMethods.iterator();
        while (iterator.hasNext()) {
            ((MovementMethod)iterator.next()).debug();
        }
    }

    public List getAmbientMovementMethods() {
        return this.ambientMovementMethods;
    }

    public List getDynamicMovementMethods() {
        return this.dynamicMovementMethods;
    }

    public void addAmbientMovementMethod(MovementMethod method) {
        this.ambientMovementMethods.add(method);
    }

    public void addDynamicMovementMethod(MovementMethod method) {
        this.dynamicMovementMethods.add(method);
    }
}

