/*
 * Decompiled with CFR 0.152.
 */
package Krabb.fe4r;

import java.io.Serializable;

public class NeuronLayer
implements Serializable {
    private int in;
    private int out;
    private transient double[] output;
    private transient double[] input;
    private double[][] weight;
    private transient double[][] lastWeightChange;

    public double[] getOutput(double[] inp) {
        System.arraycopy(inp, 0, this.input, 0, this.in);
        int o = 0;
        while (o < this.out) {
            this.output[o] = 0.0;
            int i = 0;
            while (i <= this.in) {
                int n = o;
                this.output[n] = this.output[n] + this.weight[i][o] * (i == this.in ? 1.0 : this.input[i]);
                ++i;
            }
            this.output[o] = 1.0 / (1.0 + Math.exp(-this.output[o]));
            ++o;
        }
        return (double[])this.output.clone();
    }

    public double[] propagate(double[] error) {
        double[] deltaE = new double[this.out];
        double[] delta = new double[this.in];
        int o = 0;
        while (o < this.out) {
            deltaE[o] = error[o] * Math.abs(this.output[o] * (1.0 - this.output[o]));
            int i = 0;
            while (i <= this.in) {
                double[] dArray = this.weight[i];
                int n = o;
                dArray[n] = dArray[n] + this.lastWeightChange[i][o] * 0.3;
                double[] dArray2 = this.weight[i];
                int n2 = o;
                double d = 0.3 * deltaE[o] * (i == this.in ? 1.0 : this.input[i]);
                this.lastWeightChange[i][o] = d;
                dArray2[n2] = dArray2[n2] + d;
                ++i;
            }
            ++o;
        }
        int i = 0;
        while (i < this.in) {
            int o2 = 0;
            while (o2 < this.out) {
                int n = i;
                delta[n] = delta[n] + deltaE[o2] * this.weight[i][o2];
                ++o2;
            }
            ++i;
        }
        return delta;
    }

    public NeuronLayer(int in, int out) {
        this.in = in;
        this.out = out;
        this.input = new double[in];
        this.output = new double[out];
        this.lastWeightChange = new double[in + 1][out];
        this.weight = new double[in + 1][out];
        int i = 0;
        while (i <= in) {
            int o = 0;
            while (o < out) {
                this.weight[i][o] = Math.random() - 0.5;
                ++o;
            }
            ++i;
        }
    }
}

