/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.DangerPrediction.Evaluators;

import java.util.ArrayList;
import rdt.Wraith.DangerPrediction.CachedVelocityData;
import rdt.Wraith.DangerPrediction.CommandSequence;
import rdt.Wraith.DangerPrediction.ICommandSequenceEvaluator;
import rdt.Wraith.DangerPrediction.MovementCommand;
import rdt.Wraith.DangerPrediction.PredictedRobotState;
import rdt.Wraith.EnemyPrediction.BulletPrediction;
import rdt.Wraith.EnemyPrediction.IEnemyPredictionManager;
import rdt.Wraith.EnemyPrediction.PredictedPosition;
import rdt.Wraith.IRobot;
import rdt.Wraith.Profiling.Profiler;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.FastOutsideOfBattlefield;
import rdt.Wraith.Utils.MathUtils;
import robocode.Rules;

public class ClosestDistanceToEachBullet
implements ICommandSequenceEvaluator {
    private final PredictedRobotState _currentRobotState = new PredictedRobotState();
    private final PredictedRobotState[] _predictedRobotStates;
    private long _maxPredictionTick;
    private final IRobot _robot;
    private final IEnemyPredictionManager _enemyPredictionManager;
    private final ITargeting _targeting;
    private final FastOutsideOfBattlefield OutsideOfBattlefield;
    private final double MinDistanceToTargetSq;
    private long _lastCachedRobotStateTick = -1L;
    private final int _maxCommandSequenceLength;
    private final int _arrayAccessMask;
    private final double _wallDamage;
    private final double _enemyDamage;
    private final double _botHalfSizeSquared;

    public ClosestDistanceToEachBullet(IRobot robot, IEnemyPredictionManager enemyPredictionManager, ITargeting targeting) {
        this._robot = robot;
        this._enemyPredictionManager = enemyPredictionManager;
        this._targeting = targeting;
        int battlefieldPadding = (int)Math.ceil(this._robot.getBotSizeMax() * 0.6 + 2.0);
        this.OutsideOfBattlefield = new FastOutsideOfBattlefield(robot, battlefieldPadding);
        this._botHalfSizeSquared = this._robot.getBotSizeMax() * 0.5 * (this._robot.getBotSizeMax() * 0.5);
        this.MinDistanceToTargetSq = 40000.0;
        this._wallDamage = Rules.getBulletDamage((double)3.0) * 2.0;
        this._enemyDamage = Rules.getBulletDamage((double)3.0) * 2.0;
        this._maxCommandSequenceLength = 140;
        this._predictedRobotStates = new PredictedRobotState[256];
        this._arrayAccessMask = 255;
        for (int index = 0; index < 256; ++index) {
            this._predictedRobotStates[index] = new PredictedRobotState();
        }
    }

    @Override
    public void Evaluate(CommandSequence sequence) {
        long currentTick = this._robot.getTime();
        if (this._lastCachedRobotStateTick != this._robot.getTime()) {
            this._currentRobotState.X = this._robot.getX();
            this._currentRobotState.Y = this._robot.getY();
            this._currentRobotState.Heading = this._robot.getHeadingRadians();
            this._currentRobotState.Velocity = this._robot.getVelocity();
            this._currentRobotState.PredictionTick = currentTick;
            this._lastCachedRobotStateTick = currentTick;
        }
        this.Evaluate(sequence, this._currentRobotState, currentTick);
    }

    @Override
    public void Evaluate(CommandSequence sequence, PredictedRobotState startingState, long currentTick) {
        Profiler.StartScope("Evaulate");
        double wallFitness = this.GeneratePredictedPositionsAndAssociatedData(sequence, startingState, currentTick);
        double targetFitness = this.EvaluateTargets(currentTick);
        double fitness = this.EvaluateBulletDistances(currentTick) + wallFitness + targetFitness;
        sequence.Fitness = fitness * fitness;
        Profiler.EndScope();
    }

    private double GeneratePredictedPositionsAndAssociatedData(CommandSequence sequence, PredictedRobotState startingState, long currentTick) {
        Profiler.StartScope("GeneratePredictedPositionsAndAssociatedData");
        assert (startingState.PredictionTick == currentTick) : "Starting state tick " + startingState.PredictionTick + " does not equal current tick " + currentTick;
        PredictedRobotState initialState = startingState;
        CachedVelocityData cachedVelocityData = CachedVelocityData.Get(initialState.Velocity);
        double energyLost = 0.0;
        int predictionStartingTick = (int)(currentTick + 1L);
        this._maxPredictionTick = predictionStartingTick + sequence.ActiveLength;
        int[] sequenceCommands = sequence.Sequence;
        int sequenceIndex = 0;
        int maxPredictionTick = (int)this._maxPredictionTick;
        for (int tick = predictionStartingTick; tick < maxPredictionTick; ++tick) {
            PredictedRobotState predictedState = this._predictedRobotStates[tick & this._arrayAccessMask];
            cachedVelocityData = MovementCommand.PredictCommandFast(sequenceCommands[sequenceIndex], initialState, predictedState, cachedVelocityData);
            predictedState.PredictionTick = tick;
            initialState = predictedState;
            ++sequenceIndex;
            double x = predictedState.X;
            double y = predictedState.Y;
            energyLost += this._wallDamage * this.OutsideOfBattlefield.Check(x, y);
        }
        Profiler.EndScope();
        return energyLost;
    }

    private double EvaluateBulletDistances(long currentTick) {
        Profiler.StartScope("EvaluateBulletDistances");
        BulletPrediction[] bulletPredictions = this._enemyPredictionManager.GetBulletPredictions();
        int bulletPredictionCount = this._enemyPredictionManager.GetBulletPredictionCount();
        double fitness = 0.0;
        for (int bulletIndex = 0; bulletIndex < bulletPredictionCount; ++bulletIndex) {
            int maxTickToCheckBullet;
            BulletPrediction bulletPrediction = bulletPredictions[bulletIndex];
            double closestDistanceSquared = Double.MAX_VALUE;
            int predictionStartingTick = (int)MathUtils.FastMax(currentTick + 1L, bulletPrediction.FirstPossibleInterceptTime);
            if (predictionStartingTick > (maxTickToCheckBullet = (int)MathUtils.FastMin(this._maxPredictionTick, bulletPrediction.LastPossibleInterceptTime))) continue;
            for (int tick = predictionStartingTick; tick < maxTickToCheckBullet; ++tick) {
                PredictedRobotState robotState = this._predictedRobotStates[tick & this._arrayAccessMask];
                PredictedPosition bulletPosition = bulletPrediction.Read(tick);
                assert (robotState.PredictionTick == bulletPosition.Tick) : "Robot state tick " + robotState.PredictionTick + " does not equal bullet position tick " + bulletPosition.Tick;
                double deltaX = bulletPosition.X - robotState.X;
                double deltaY = bulletPosition.Y - robotState.Y;
                double distanceSquared = deltaX * deltaX + deltaY * deltaY;
                closestDistanceSquared = MathUtils.FastMin(distanceSquared, closestDistanceSquared);
            }
            closestDistanceSquared = MathUtils.FastMax(closestDistanceSquared, this._botHalfSizeSquared) - this._botHalfSizeSquared + 0.1;
            fitness += bulletPrediction.DamageDealt * bulletPrediction.Weight / closestDistanceSquared;
        }
        Profiler.EndScope();
        return fitness;
    }

    private double EvaluateTargets(long currentTick) {
        Profiler.StartScope("Evaluate Targets");
        ArrayList<Target> targets = this._targeting.GetTargets();
        int targetCount = targets.size();
        double fitness = 0.0;
        long predictionStartingTick = currentTick + 1L;
        for (int index = 0; index < targetCount; ++index) {
            Target target = targets.get(index);
            if (!target.Valid) continue;
            for (long tick = predictionStartingTick; tick < this._maxPredictionTick; ++tick) {
                PredictedRobotState robotState = this._predictedRobotStates[(int)tick & this._arrayAccessMask];
                assert (robotState.PredictionTick == tick) : "Evaluating targets but robot prediction tick " + robotState.PredictionTick + " does not equal tick " + tick;
                long targetPredictedSnapshotTick = target.GetSafePredictedTick(tick);
                RobotSnapshot predictedEnemyPosition = target.RobotSnapshots.Read(targetPredictedSnapshotTick);
                double dX = robotState.X - predictedEnemyPosition.LocationX;
                double dY = robotState.Y - predictedEnemyPosition.LocationY;
                double distanceSq = dX * dX + dY * dY - this._botHalfSizeSquared;
                if (!((distanceSq = MathUtils.FastMax(1.0E-5, distanceSq)) <= this.MinDistanceToTargetSq)) continue;
                fitness += this._enemyDamage / distanceSq;
            }
        }
        Profiler.EndScope();
        return fitness;
    }
}

