/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.RobotHistory;

import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.RobotHistory.RobotHistory;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.Utils.MathUtils;
import rdt.AgentSmith.Utils.RuleUtils;
import robocode.util.Utils;

public class RobotSnapshotUtils {
    public static void FillInSnapshot(IRobot robot, RobotSnapshot snapshot, RobotHistory history, double x, double y, double velocity, double absHeading, double targetX, double targetY, double absAngleFromItsTarget, double energy) {
        snapshot.Tick = robot.getTime();
        snapshot.LocationX = x;
        snapshot.LocationY = y;
        snapshot.AbsoluteHeading = absHeading;
        snapshot.VelocityAlongHeading = velocity;
        snapshot.LateralVelocity = Math.abs(velocity * MathUtils.FastSin(absHeading - absAngleFromItsTarget));
        snapshot.AdvancingVelocity = velocity * -MathUtils.FastCos(absHeading - absAngleFromItsTarget);
        snapshot.AbsoluteAngleFromItsTarget = absAngleFromItsTarget;
        snapshot.Energy = energy;
        double diffX = x - targetX;
        double diffY = y - targetY;
        snapshot.DistanceToItsTarget = Math.sqrt(diffX * diffX + diffY * diffY);
        double previousVelocity = snapshot.VelocityAlongHeading;
        double previousDirection = 0.0;
        double previousX = x;
        double previousY = y;
        double previousNonZeroVelocity = 0.0;
        long previousTicksSinceDirectionChange = 0L;
        long previousTicksSinceDeceleration = 0L;
        if (history.SnapshotCount > 1) {
            RobotSnapshot lastSnapshot = history.Snapshots.get(0);
            previousVelocity = lastSnapshot.VelocityAlongHeading;
            previousDirection = lastSnapshot.RotationDirectionToAgentSmith;
            previousX = lastSnapshot.LocationX;
            previousY = lastSnapshot.LocationY;
            previousNonZeroVelocity = lastSnapshot.LastNonZeroVelocityAlongHeading;
            previousTicksSinceDirectionChange = lastSnapshot.TicksSinceDirectionChange;
            previousTicksSinceDeceleration = lastSnapshot.TicksSinceDeceleration;
        }
        snapshot.LastNonZeroVelocityAlongHeading = previousNonZeroVelocity;
        if (!Utils.isNear((double)snapshot.VelocityAlongHeading, (double)0.0)) {
            snapshot.LastNonZeroVelocityAlongHeading = snapshot.VelocityAlongHeading;
        }
        snapshot.TicksSinceDirectionChange = Math.signum(snapshot.LastNonZeroVelocityAlongHeading) != Math.signum(previousNonZeroVelocity) ? 0L : previousTicksSinceDirectionChange + 1L;
        snapshot.AccelerationAlongHeading = velocity - previousVelocity;
        snapshot.AccelerationAlongHeading = Math.max(Math.min(snapshot.AccelerationAlongHeading, 2.0), -2.0);
        snapshot.AccelerationAlongVelocityVector = snapshot.AccelerationAlongHeading * Math.signum(snapshot.VelocityAlongHeading);
        snapshot.TicksSinceDeceleration = snapshot.AccelerationAlongVelocityVector < 0.0 ? 0L : previousTicksSinceDeceleration + 1L;
        double prevAngle = MathUtils.GetAngle(targetX, targetY, previousX, previousY);
        prevAngle = Utils.normalAbsoluteAngle((double)prevAngle);
        double diff = absAngleFromItsTarget - prevAngle;
        diff = Utils.normalRelativeAngle((double)diff);
        double newDirection = 1.0;
        if (Utils.isNear((double)0.0, (double)diff) || Math.abs(velocity) < 1.0) {
            newDirection = previousDirection;
        } else if (diff < 0.0) {
            newDirection = -1.0;
        }
        snapshot.RotationDirectionToAgentSmith = newDirection;
        int oldSnapshotIndex = Math.min(10, history.SnapshotCount - 1);
        double distanceLast10 = 0.0;
        if (oldSnapshotIndex >= 0) {
            RobotSnapshot oldSnapshot = history.Snapshots.get(oldSnapshotIndex);
            double dX = x - oldSnapshot.LocationX;
            double dY = y - oldSnapshot.LocationY;
            distanceLast10 = Math.sqrt(dX * dX + dY * dY);
        }
        snapshot.DistanceLast10 = distanceLast10;
        double dX = MathUtils.FastSin(absHeading);
        double dY = MathUtils.FastCos(absHeading);
        snapshot.DistanceToWallAhead = RuleUtils.GetDistanceToWall(x, y, dX, dY);
        snapshot.DistanceToWallBehind = RuleUtils.GetDistanceToWall(x, y, -dX, -dY);
    }
}

