/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun.segmentation;

import ags.muse.gun.segmentation.Dimension;
import java.util.ArrayList;

public class SegmentConfig {
    private final Dimension.Data<double[]> definition;
    private final Dimension.Data<Boolean> interpolation;
    private final ArrayList<Dimension> dimensions;

    public SegmentConfig(SegmentConfig old) {
        this.definition = new Dimension.Data<double[]>(old.definition);
        this.interpolation = new Dimension.Data<Boolean>(old.interpolation);
        this.dimensions = new ArrayList<Dimension>(old.dimensions);
    }

    public SegmentConfig() {
        this.definition = new Dimension.Data();
        this.interpolation = new Dimension.Data();
        this.dimensions = new ArrayList();
    }

    public void add(Dimension d, boolean interpolated, double ... s) {
        this.definition.put(d, s);
        this.interpolation.put(d, interpolated);
        this.dimensions.add(d);
    }

    public double[] getFloatIndicies(Dimension.Data<Double> data) {
        double[] indicies = new double[this.definition.size()];
        int a = 0;
        for (Dimension d : this.dimensions) {
            double[] bounds = (double[])this.definition.get((Object)d);
            double value = (Double)data.get((Object)d);
            if (value >= bounds[0]) {
                int i = 0;
                while (i < bounds.length) {
                    if (i + 1 >= bounds.length && value >= bounds[i]) {
                        indicies[a] = i;
                        break;
                    }
                    if (value >= bounds[i] && value < bounds[i + 1]) {
                        indicies[a] = (double)i + (value - bounds[i]) / (bounds[i + 1] - bounds[i]);
                        break;
                    }
                    ++i;
                }
            }
            ++a;
            if (((Boolean)this.interpolation.get((Object)d)).booleanValue()) continue;
            indicies[a] = Math.round(indicies[a]);
        }
        return indicies;
    }

    public int getIndex(int ... indicies) {
        int multiplier = 1;
        int index = 0;
        int a = 0;
        for (Dimension d : this.definition.keySet()) {
            double[] bounds = (double[])this.definition.get((Object)d);
            index += indicies[a] * multiplier;
            multiplier *= bounds.length;
            ++a;
        }
        return index;
    }

    public int getLength() {
        int multiplier = 1;
        for (Dimension d : this.definition.keySet()) {
            double[] bounds = (double[])this.definition.get((Object)d);
            multiplier *= bounds.length;
        }
        return multiplier;
    }

    public int getSegmentLength(int i) {
        return this.getSegmentLength(this.dimensions.get(i));
    }

    public int getSegmentLength(Dimension d) {
        return ((double[])this.definition.get((Object)d)).length;
    }

    public static void main(String[] args) {
        SegmentConfig conf = new SegmentConfig(){
            {
                this.add(Dimension.ACCEL, true, 0.0, 4.0, 8.0);
            }
        };
        Dimension.Data<Double> s = new Dimension.Data<Double>();
        s.put(Dimension.ACCEL, 1.0);
        double[] foo = conf.getFloatIndicies(s);
        System.out.println("Value: " + foo[0]);
    }
}

