/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4;

import gre.svman4.morfeas.EnemyState;
import gre.svman4.morfeas.EnemyWaveBullet;
import gre.svman4.morfeas.GuessFactorTargetingGun;
import gre.svman4.morfeas.Gun;
import gre.svman4.morfeas.LinearTargetingGun;
import gre.svman4.morfeas.MineWaveBullet;
import gre.svman4.morfeas.MinimumRiskMovement;
import gre.svman4.morfeas.Movement;
import gre.svman4.morfeas.OneVsOneMovementStrategy;
import gre.svman4.morfeas.RamMovement;
import gre.svman4.morfeas.VirtualBullet;
import gre.svman4.morfeas.WaveSurfer;
import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public class Morfeas
extends AdvancedRobot {
    private static final double WALL_MARGIN = 60.0;
    private static boolean _showBattleField = true;
    public static Rectangle2D _battleField;
    private static final HashMap<String, EnemyState> _enemies;
    static ArrayList<EnemyWaveBullet> _enemyWaves;
    private static ArrayList<Gun> _guns;
    private static Gun _mainGun;
    static RobotState _me;
    static ArrayList<MineWaveBullet> _mineWaves;
    static HashMap<String, Movement> _movement;
    static Rectangle2D.Double _movingPlace;
    private static boolean _showGun;
    private static boolean _showMovement;
    private static boolean _showRadar;
    public static double TARGET_ENERGY_LIMIT_RAM;
    private static EnemyState _target;
    public int DISTANCE_FOR_RELATIVE_POSITION = 80;
    private final float _shootingEnergyLimit = 3.0f;
    private final double _gunTurningRemainingLimit = 2.0;
    private Movement _mainMovement;
    private Strategy _strategy;
    private final ArrayList<VirtualBullet> _virtualBullets = new ArrayList();
    public static final boolean DEBUG_MODE = false;

    private void doJobsOnStart() {
        _battleField = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        _movingPlace = new Rectangle2D.Double(60.0, 60.0, this.getBattleFieldWidth() - 120.0, this.getBattleFieldHeight() - 120.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setMoves();
        this.setGuns();
    }

    private void setMoves() {
        MinimumRiskMovement minimumRiskMovement = new MinimumRiskMovement(_me, _movingPlace, _enemies);
        _movement.put(minimumRiskMovement.getName(), minimumRiskMovement);
        RamMovement ramMovement = new RamMovement(_me, _target);
        _movement.put(ramMovement.getName(), ramMovement);
        WaveSurfer waveSurfer = new WaveSurfer(_me, _battleField, _target, _enemyWaves);
        _movement.put(waveSurfer.getName(), waveSurfer);
    }

    private void setGuns() {
        _guns = new ArrayList();
        _guns.add(new GuessFactorTargetingGun());
        _mainGun = _guns.get(0);
    }

    private void createNewMineWaveToTarget(boolean paint) {
        MineWaveBullet mWave = new MineWaveBullet();
        mWave.bulletVelocity = Rules.getBulletSpeed((double)this.calculateBulletPower(_target));
        mWave.directAngle = _me.getAngleTo(_target);
        mWave.distanceTraveled = 0.0;
        mWave.enemy = _target;
        mWave.fireTime = this.getTime();
        mWave.fireLocation = new FieldPoint(_me);
        mWave.distanceToEnemyPosition = _me.distance(_target);
        mWave.enemyVelocity = Morfeas._target.velocity;
        mWave.lastEnemyVelocity = Morfeas._target.lastVelocity;
        mWave.mineRobotVelocity = Morfeas._me.velocity;
        mWave.lateralDirection = Morfeas._target.lateralDirection;
        mWave.moveTime = Morfeas._target.moveTime;
        mWave.relativePosition = Morfeas._target.relativePosition;
        mWave.paint = paint;
        _mineWaves.add(mWave);
    }

    public void onBattleEnded(BattleEndedEvent event) {
    }

    private void createNewVirtualBullets(double bulletPower) {
        Iterator<Gun> it = _guns.iterator();
        int gunNumber = 0;
        while (it.hasNext()) {
            VirtualBullet vBullet = new VirtualBullet(Morfeas._me.x, Morfeas._me.y);
            Gun tempGun = it.next();
            ++tempGun.gunShootingCounter;
            vBullet.heading = tempGun.getFiringAngle(_me, _target, bulletPower);
            vBullet.velocity = Rules.getBulletSpeed((double)bulletPower);
            vBullet.target = _target;
            vBullet.gunNumber = gunNumber++;
            this._virtualBullets.add(vBullet);
        }
    }

    private void findBetterGunForThisTarget() {
        long bestScore = -1L;
        int gunNumber = 0;
        for (Gun gun : _guns) {
            if ((long)Morfeas._target.hits[gunNumber] > bestScore) {
                bestScore = Morfeas._target.hits[gunNumber];
                _mainGun = gun;
            }
            ++gunNumber;
        }
    }

    private void drawVirtualBullets(Graphics2D g) {
        for (VirtualBullet bullet : this._virtualBullets) {
            Color color = _guns.get(bullet.gunNumber).getColor();
            g.setColor(color);
            g.fillOval((int)bullet.x - 3, (int)bullet.y - 3, 6, 6);
        }
    }

    private void createNewEnemyWave(EnemyState enemy, double looseEnergy) {
        EnemyWaveBullet ew = new EnemyWaveBullet();
        ew.fireTime = this.getTime() - 1L;
        ew.enemy = enemy;
        ew.bulletVelocity = Rules.getBulletSpeed((double)looseEnergy);
        ew.distanceTraveled = Rules.getBulletSpeed((double)looseEnergy);
        ew.lateralDirection = (int)enemy.surfDirections.getBeforeLastValue();
        ew.directAngle = enemy.surfAbsBearing.getBeforeLastValue();
        ew.fireLocation = (FieldPoint)enemy.clone();
        ew.mineRobotVelocity = Math.abs(Morfeas._me.velocity);
        ew.distanceToEnemyPosition = _me.distance(enemy);
        ew.relativePosition = Morfeas._me.relativePosition;
        _enemyWaves.add(ew);
    }

    private int getRelativePosition(FieldPoint point) {
        int temp = 0;
        if (point.x < (double)this.DISTANCE_FOR_RELATIVE_POSITION || point.x > this.getBattleFieldWidth() - (double)this.DISTANCE_FOR_RELATIVE_POSITION) {
            ++temp;
        }
        if (point.y < (double)this.DISTANCE_FOR_RELATIVE_POSITION || point.y > this.getBattleFieldHeight() - (double)this.DISTANCE_FOR_RELATIVE_POSITION) {
            ++temp;
        }
        return temp;
    }

    private double calculateBulletPower(EnemyState enemy) {
        if (enemy == null) {
            return 0.0;
        }
        double distance = enemy.distance(_me);
        double answer = Math.min(2.0 * (300.0 / distance), enemy.energy / 3.0);
        return answer;
    }

    private void gun() {
        if (!Morfeas._target.isAlive) {
            return;
        }
        double bulletPower = this.calculateBulletPower(_target);
        double firingAngle = _mainGun.getFiringAngle(_me, _target, bulletPower);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(firingAngle - this.getGunHeadingRadians())));
        if (this.getGunHeat() == 0.0 && this.getEnergy() > 3.0 && Math.abs(this.getGunTurnRemaining()) < 2.0) {
            this.setFire(bulletPower);
            this.createNewMineWaveToTarget(true);
        }
    }

    void movement() {
        if (null == this._strategy) {
            this._mainMovement = _movement.get("MinimumRiskMovement");
        } else {
            switch (this._strategy) {
                case OneVsOne: {
                    this._mainMovement = _movement.get("Wave surfer");
                    ((OneVsOneMovementStrategy)this._mainMovement).setTarget(_target);
                    break;
                }
                case RAM: {
                    this._mainMovement = _movement.get("Ram");
                    ((RamMovement)this._mainMovement).setTarget(_target);
                    break;
                }
                default: {
                    this._mainMovement = _movement.get("MinimumRiskMovement");
                }
            }
        }
        this._mainMovement.run(this);
    }

    public void onBulletHit(BulletHitEvent evnt) {
        EnemyState enemy = _enemies.get(evnt.getName());
        if (enemy == null) {
            enemy = new EnemyState(this, evnt.getName());
            _enemies.put(evnt.getName(), enemy);
        }
        enemy.energy = evnt.getEnergy();
    }

    public void onBulletHitBullet(BulletHitBulletEvent evnt) {
        if (_enemyWaves.isEmpty()) {
            return;
        }
        FieldPoint hitBulletLocation = new FieldPoint(evnt.getBullet().getX(), evnt.getBullet().getY());
        EnemyWaveBullet hitWave = null;
        for (EnemyWaveBullet enemyWaveBullet : _enemyWaves) {
            double distanceDiff = Math.abs(enemyWaveBullet.distanceTraveled - hitBulletLocation.distance(enemyWaveBullet.fireLocation));
            if (!(distanceDiff < 20.0)) continue;
            hitWave = enemyWaveBullet;
            break;
        }
        if (hitWave != null) {
            hitWave.logEnemyHit(hitBulletLocation);
            _enemyWaves.remove(hitWave);
        }
    }

    public void onDeath(DeathEvent event) {
        this._virtualBullets.clear();
    }

    public void onHitByBullet(HitByBulletEvent evnt) {
        if (_enemyWaves.isEmpty()) {
            return;
        }
        FieldPoint hitBulletLocation = new FieldPoint(_me);
        EnemyWaveBullet hitWave = null;
        for (int x = 0; x < _enemyWaves.size(); ++x) {
            EnemyWaveBullet ew = _enemyWaves.get(x);
            if (!(Math.abs(ew.distanceTraveled - _me.distance(ew.fireLocation)) < 50.0) || !(Math.abs(evnt.getBullet().getVelocity() - ew.bulletVelocity) < 0.001)) continue;
            hitWave = ew;
            break;
        }
        if (hitWave != null) {
            hitWave.logEnemyHit(hitBulletLocation);
            _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
        }
    }

    public void onKeyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 71: {
                _showGun = !_showGun;
                break;
            }
            case 70: {
                _showBattleField = !_showBattleField;
                break;
            }
            case 77: {
                _showMovement = !_showMovement;
                break;
            }
            case 82: {
                _showRadar = !_showRadar;
            }
        }
    }

    public void onPaint(Graphics2D g) {
    }

    public Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = (range - value) / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    public void onRobotDeath(RobotDeathEvent evnt) {
        EnemyState en = _enemies.get(evnt.getName());
        if (en == null) {
            return;
        }
        en.isAlive = false;
    }

    public void onRoundEnded(RoundEndedEvent evnt) {
        this._virtualBullets.clear();
        _enemyWaves.clear();
        _mineWaves.clear();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyState enemy;
        if (this._strategy == Strategy.Melee) {
            // empty if block
        }
        if (this._strategy == Strategy.OneVsOne) {
            double angleToEnemy = this.getHeadingRadians() + e.getBearingRadians();
            double moduleTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this.getRadarHeadingRadians()));
            double extraTurn = Math.min(Math.atan(90.0 / e.getDistance()), Rules.RADAR_TURN_RATE_RADIANS);
            this.setTurnRadarRightRadians(moduleTurn += moduleTurn < 0.0 ? -extraTurn : extraTurn);
        }
        if ((enemy = _enemies.get(e.getName())) == null) {
            enemy = new EnemyState(e.getName(), _guns.size());
            _enemies.put(e.getName(), enemy);
        }
        enemy.setLocation(_me.project(e.getDistance(), this.getHeadingRadians() + e.getBearingRadians()));
        enemy.deltaHeading = enemy.heading - e.getHeadingRadians();
        enemy.heading = e.getHeadingRadians();
        enemy.lastVelocity = enemy.velocity;
        enemy.velocity = e.getVelocity();
        enemy.relativePosition = this.getRelativePosition(enemy);
        enemy.moveTime = enemy.velocity == 0.0 ? 0 : ++enemy.moveTime;
        if (e.getVelocity() != 0.0) {
            double enemyAbsoluteBearing = e.getBearingRadians() + Morfeas._me.heading;
            double enemyLateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
            enemy.lateralDirection = enemyLateralVelocity >= 0.0 ? 1 : -1;
        }
        enemy.surfDirections.insertValue(this.getVelocity() * Math.sin(e.getBearingRadians()) >= 0.0 ? 1.0 : -1.0);
        enemy.surfAbsBearing.insertValue(e.getBearingRadians() + this.getHeadingRadians() + Math.PI);
        double looseEnergy = enemy.energy - e.getEnergy();
        if (looseEnergy > 0.0 && looseEnergy < 3.01 && looseEnergy != Math.abs(enemy.lastVelocity - enemy.velocity) * 0.5 - 1.0) {
            this.createNewEnemyWave(enemy, looseEnergy);
        }
        enemy.energy = e.getEnergy();
        if (!Morfeas._target.isAlive || enemy.distance(_me) < _target.distance(_me)) {
            _target = enemy;
        }
    }

    public void onStatus(StatusEvent evnt) {
        _me.setLocation(this.getX(), this.getY());
        Morfeas._me.heading = this.getHeadingRadians();
        Morfeas._me.energy = this.getEnergy();
        Morfeas._me.velocity = this.getVelocity();
        Morfeas._me.relativePosition = this.getRelativePosition(_me);
        this.updateEnemyWaves();
        this.updateMineWaves();
    }

    public void run() {
        if (_movingPlace == null) {
            this.doJobsOnStart();
        }
        Morfeas._target.isAlive = false;
        for (EnemyState en : _enemies.values()) {
            en.isAlive = true;
        }
        while (true) {
            if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this._strategy = this.getOthers() > 1 ? Strategy.Melee : (this.getOthers() == 1 && Morfeas._target.energy < 1.0 ? Strategy.RAM : Strategy.OneVsOne);
            this.movement();
            this.gun();
            this.execute();
        }
    }

    public void updateEnemyWaves() {
        try {
            Iterator<EnemyWaveBullet> enemyWaveIterator = _enemyWaves.iterator();
            while (enemyWaveIterator.hasNext()) {
                EnemyWaveBullet ew = enemyWaveIterator.next();
                ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
                if (!(ew.distanceTraveled > _me.distance(ew.fireLocation) + 50.0)) continue;
                enemyWaveIterator.remove();
            }
        }
        catch (Exception exp) {
            System.out.println("Update enemy Waves");
        }
    }

    private void updateMineWaves() {
        Iterator<MineWaveBullet> mWaveIterator = _mineWaves.iterator();
        while (mWaveIterator.hasNext()) {
            MineWaveBullet mWave = mWaveIterator.next();
            mWave.distanceTraveled = (double)(this.getTime() - mWave.fireTime) * mWave.bulletVelocity;
            try {
                double distance = mWave.enemy.distance(mWave.fireLocation) - 18.0;
                if (!(mWave.distanceTraveled > distance)) continue;
                mWave.logGunHit();
                mWaveIterator.remove();
            }
            catch (Exception exception) {}
        }
    }

    private void updateVirtualBullet() {
        try {
            Iterator<VirtualBullet> ite = this._virtualBullets.iterator();
            while (ite.hasNext()) {
                VirtualBullet temp = ite.next();
                temp.setLocation(temp.project(temp.velocity, temp.heading));
                if (!_battleField.contains(temp)) {
                    ite.remove();
                    continue;
                }
                if (!(temp.distance(temp.target) < 15.0)) continue;
                int n = temp.gunNumber;
                temp.target.hits[n] = temp.target.hits[n] + 1;
                ++Morfeas._guns.get((int)temp.gunNumber).gunSuccessShootingCounter;
                ite.remove();
            }
        }
        catch (Exception exp) {
            System.out.println("UpdateVirtualBullet error");
        }
    }

    static {
        _enemies = new HashMap();
        _enemyWaves = new ArrayList();
        _mainGun = new LinearTargetingGun();
        _me = new RobotState();
        _mineWaves = new ArrayList();
        _movement = new HashMap();
        _showGun = true;
        _showMovement = true;
        _showRadar = true;
        TARGET_ENERGY_LIMIT_RAM = 3.0;
        _target = new EnemyState("", 0);
    }

    private static enum Strategy {
        Melee,
        OneVsOne,
        RAM;

    }
}

