/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pedersen.core.Competitor;
import pedersen.core.GameState;
import pedersen.opponent.Target;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnRound;

public class Teammate
extends Competitor.CompetitorBase
implements OnRound {
    private final String name;
    private boolean isActive = true;
    private Target scannerTarget = null;
    private Target turretTarget = null;
    private static final Map<String, Teammate> vault = new HashMap<String, Teammate>();

    Teammate(String name) {
        this.name = name;
        NotificationSubsystem.getInstance().subscribeOnRound(this);
        this.onRound(GameState.getInstance().getRound());
    }

    @Override
    public void onRound(int round) {
        super.onRound(round);
        this.isActive = true;
    }

    public String getName() {
        return this.name;
    }

    void deactivate() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive && super.isSnapshotValid();
    }

    public Target getScannerTarget() {
        return this.scannerTarget;
    }

    public void setScannerTarget(Target scannerTarget) {
        this.scannerTarget = scannerTarget;
    }

    public Target getTurretTarget() {
        return this.turretTarget;
    }

    public void setTurretTarget(Target turretTarget) {
        this.turretTarget = turretTarget;
    }

    public static Teammate findByName(String name) {
        return vault.get(name);
    }

    public static void add(String[] teammates) {
        if (teammates != null) {
            String[] stringArray = teammates;
            int n = teammates.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                vault.put(name, new Teammate(name));
                ++n2;
            }
        }
    }

    public static Set<Teammate> getActiveTeammates() {
        HashSet<Teammate> teammates = new HashSet<Teammate>();
        for (Teammate e : vault.values()) {
            if (!e.isActive()) continue;
            teammates.add(e);
        }
        return teammates;
    }

    public static Iterable<Teammate> getLivingTeammates() {
        HashSet<Teammate> teammates = new HashSet<Teammate>();
        for (Teammate e : vault.values()) {
            if (!e.isActive) continue;
            teammates.add(e);
        }
        return teammates;
    }
}

