/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.vector;

import pedersen.movement.MovementMethodBase;
import pedersen.movement.vector.MovementMethodVector;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.Position;
import pedersen.physics.Vector;
import pedersen.physics.constant.VectorImpl;

public abstract class MovementMethodVectorBase
extends MovementMethodBase
implements MovementMethodVector {
    protected final double alwaysOnRange;
    protected final double alwaysOnPower;
    protected final double fieldMagnitude;

    public MovementMethodVectorBase(double newFieldMagnitude, double newAlwaysOnRange, double newAlwaysOnPower) {
        this.alwaysOnRange = newAlwaysOnRange;
        this.alwaysOnPower = newAlwaysOnPower;
        this.fieldMagnitude = newFieldMagnitude;
    }

    protected Vector getTangentFieldVector(Position subject, Position fieldPosition) {
        return new VectorImpl((HasDirection)fieldPosition.getBearing(subject).getTangentAngle(), this.getFieldMagnitude(fieldPosition.getDistance(subject).distance()));
    }

    protected Vector getFieldVector(Direction direction, double distance) {
        return new VectorImpl((HasDirection)direction, this.getFieldMagnitude(distance));
    }

    protected double getFieldMagnitude(double distance) {
        return distance < this.alwaysOnRange ? this.alwaysOnPower : this.calculateMagnitude(this.fieldMagnitude, distance);
    }

    private double calculateMagnitude(double force, double distance) {
        double ratio = force / Math.max(1.0, distance);
        return ratio * Math.abs(ratio);
    }
}

