/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics.constant;

import pedersen.debug.DebuggableBase;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.HasMagnitude;
import pedersen.physics.HasVector;
import pedersen.physics.Magnitude;
import pedersen.physics.Vector;
import pedersen.physics.constant.MagnitudeImpl;

public class VectorImpl
extends DebuggableBase
implements Vector {
    private Direction direction;
    private Magnitude magnitude;

    public VectorImpl(HasDirection direction, HasMagnitude magnitude) {
        this.direction = direction.getDirection();
        this.magnitude = magnitude.getMagnitude();
    }

    public VectorImpl(VectorImpl other) {
        this((HasDirection)other.getDirection(), other.getMagnitude());
    }

    public VectorImpl(HasDirection direction, double magnitude) {
        this(direction, new MagnitudeImpl(magnitude));
    }

    @Override
    public boolean equalsVector(HasVector other) {
        return this.direction.equalsDirection(other.getVector().getDirection()) && this.magnitude.equalsMagnitude(other.getVector().getMagnitude());
    }

    @Override
    public Vector getVector() {
        return this;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public Magnitude getMagnitude() {
        return this.magnitude;
    }
}

