/*
 * Decompiled with CFR 0.152.
 */
package rdt.Guns;

import java.awt.Graphics2D;
import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataSnapshot;
import rdt.SubsystemMode;
import rdt.Targeting.Targeting;
import rdt.Utils.MathUtils;
import robocode.BulletHitBulletEvent;
import robocode.Rules;
import robocode.util.Utils;

public class CloseUpGunMode
extends SubsystemMode {
    private long _nextFireTurn = 0L;
    private double _nextFirePower = 0.0;
    private double _targetFiringAngle = 0.0;

    public CloseUpGunMode() {
        this.Initialise("Close Up Gun");
    }

    @Override
    public void UpdateHighestPriority() {
        RobotData currentTarget = Targeting.GetCurrentTarget();
        if (currentTarget == null || !currentTarget.Valid || currentTarget.NumSnapshots < 5 || currentTarget.Dead) {
            return;
        }
        this._nextFirePower = 3.0;
        if (this._nextFirePower <= 0.0) {
            return;
        }
        if (this._nextFireTurn == AgentSmith.Instance().getTime() && AgentSmith.Instance().getGunTurnRemaining() == 0.0 && AgentSmith.Instance().getGunHeat() <= 0.0) {
            AgentSmith.Instance().setFire(this._nextFirePower);
            return;
        }
        this._targetFiringAngle = this.GetFireAngle(currentTarget);
        AgentSmith.Instance().setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this._targetFiringAngle - AgentSmith.Instance().getGunHeadingRadians())));
        this._nextFireTurn = AgentSmith.Instance().getTime() + 1L;
    }

    private double GetFireAngle(RobotData target) {
        RobotDataSnapshot targetSnapshot = target.Snapshots.get(0);
        double firingX = this.GetFiringLocationX();
        double firingY = this.GetFiringLocationY();
        double absHeading = MathUtils.GetAngle(firingX, firingY, targetSnapshot.LocationX, targetSnapshot.LocationY);
        return absHeading + Math.asin(targetSnapshot.VelocityAlongHeading / Rules.getBulletSpeed((double)this._nextFirePower) * Math.sin(targetSnapshot.AbsoluteHeading - absHeading));
    }

    public double GetFiringLocationX() {
        if (AgentSmith.Instance().GetPredictedPosition() != null) {
            return AgentSmith.Instance().GetPredictedPosition().X;
        }
        return AgentSmith.Instance().getX();
    }

    public double GetFiringLocationY() {
        if (AgentSmith.Instance().GetPredictedPosition() != null) {
            return AgentSmith.Instance().GetPredictedPosition().Y;
        }
        return AgentSmith.Instance().getY();
    }

    @Override
    public float GetPriority() {
        RobotData currentTarget = Targeting.GetCurrentTarget();
        if (currentTarget == null) {
            return 0.0f;
        }
        if (!currentTarget.Valid) {
            return 0.0f;
        }
        if (currentTarget.Snapshots.get((int)0).DistanceToTarget > 75.0) {
            return 0.0f;
        }
        return 2.0f;
    }

    @Override
    public void Shutdown() {
    }

    @Override
    public void Update() {
    }

    @Override
    public void OnRoundStart() {
        this._nextFireTurn = 0L;
        this._nextFirePower = 0.0;
    }

    @Override
    public void OnBulletHitBulletEvent(BulletHitBulletEvent event) {
    }

    @Override
    public void DebugDraw(Graphics2D gfx) {
    }
}

