/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit2002;

import fnc.bandit2002.Attractor;
import fnc.bandit2002.DummyAttractor;
import fnc.bandit2002.Force;
import fnc.bandit2002.Position;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class ForceField {
    Hashtable attractors;
    DummyAttractor[] dummies;
    double w;
    double h;
    PrintStream output;
    boolean tron_emulation;
    int no_dummies = 0;

    public int count() {
        return this.attractors.size();
    }

    public Force force(Position arg_p, long arg_time) {
        Force result = new Force();
        Enumeration i = this.attractors.keys();
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            Attractor a = (Attractor)this.attractors.get(key);
            result.add(a.force(arg_p, arg_time));
        }
        double buffer_length = 100.0;
        if (arg_p.x < buffer_length) {
            result.vx += this.wallPower(arg_p.x);
        } else if (arg_p.x > this.w - buffer_length) {
            result.vx -= this.wallPower(this.w - arg_p.x);
        }
        if (arg_p.y < buffer_length) {
            result.vy += this.wallPower(arg_p.y);
        } else if (arg_p.y > this.h - buffer_length) {
            result.vy -= this.wallPower(this.h - arg_p.y);
        }
        return result;
    }

    public final double wallPower(double arg_x) {
        return 100.0 * (double)this.attractors.size() / (1.0 + Math.pow(arg_x, 0.4));
    }

    public boolean contains(String arg_name) {
        return this.attractors.containsKey(arg_name);
    }

    public Attractor getAttractor(String arg_name) {
        return (Attractor)this.attractors.get(arg_name);
    }

    public void removeAttractor(String name) {
        this.attractors.remove(name);
    }

    public void addAttractor(Attractor arg_a) {
        this.attractors.put(arg_a.getName(), arg_a);
    }

    public void countZero() {
        int headcount = this.attractors.size();
        Enumeration i = this.attractors.keys();
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            Attractor a = (Attractor)this.attractors.get(key);
            a.countZero();
            a.headcount = headcount;
        }
    }

    public Attractor findScanTarget(long arg_time) {
        long best_scantime = arg_time + 1L;
        long scantime = 0L;
        Attractor best = null;
        Enumeration i = this.attractors.keys();
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            Attractor a = (Attractor)this.attractors.get(key);
            scantime = a.getScanTime();
            if (scantime >= best_scantime) continue;
            best_scantime = scantime;
            best = a;
        }
        return best;
    }

    public Attractor findTarget(Position arg_p, double arg_heading) {
        Attractor a;
        Object key;
        double min_distance = (double)4 * this.h;
        double max_bounty = 0.0;
        Attractor best = null;
        Enumeration i = this.attractors.keys();
        while (i.hasMoreElements()) {
            key = i.nextElement();
            a = (Attractor)this.attractors.get(key);
            double distance = arg_p.distance(a.getPosition());
            if (!(distance < min_distance)) continue;
            min_distance = distance;
        }
        i = this.attractors.keys();
        while (i.hasMoreElements()) {
            key = i.nextElement();
            a = (Attractor)this.attractors.get(key);
            double bounty = a.bounty(min_distance, arg_p, arg_heading);
            if (!(bounty > max_bounty)) continue;
            max_bounty = bounty;
            best = a;
        }
        return best;
    }

    public void dump(PrintStream o) {
        Enumeration i = this.attractors.keys();
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            Attractor a = (Attractor)this.attractors.get(key);
            a.dump(o);
        }
    }

    public ForceField(PrintStream arg_stream, double arg_w, double arg_h) {
        this.w = arg_w;
        this.h = arg_h;
        this.output = arg_stream;
        this.attractors = new Hashtable();
        this.dummies = new DummyAttractor[this.no_dummies];
        this.tron_emulation = false;
    }
}

