/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.artillery.strategies;

import ghent.common.Target;
import ghent.modules.artillery.Ballistics;
import ghent.modules.artillery.TimestampedLocation;
import ghent.modules.artillery.strategies.ITargetingStrategy;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.util.Utils;

public abstract class AbstractTargetingStrategy
implements ITargetingStrategy {
    private static final double MAX_DAMAGE = Rules.getBulletDamage((double)3.0);
    private static final double MIN_DAMAGE = Rules.getBulletDamage((double)0.1);
    protected AdvancedRobot _robot;
    protected Double _maxPower = null;

    public AbstractTargetingStrategy(AdvancedRobot _robot) {
        this._robot = _robot;
    }

    public AbstractTargetingStrategy(AdvancedRobot _robot, Double _maxPower) {
        this._robot = _robot;
        this._maxPower = _maxPower;
    }

    public Ballistics getBallistics(Target target) {
        if (target == null) {
            return null;
        }
        double tmpPower = Math.min(this.powerToKill(target.getEnergy()), this._robot.getEnergy() / 2.0);
        double bPower = this._maxPower != null ? Math.min(tmpPower, this._maxPower) : tmpPower;
        TimestampedLocation estimation = this.getEstimatedLocation(target, bPower);
        if (estimation == null) {
            return null;
        }
        double angle = estimation.getBearing(this._robot.getX(), this._robot.getY());
        double adjustedAngle = Utils.normalRelativeAngleDegrees((double)(angle - this._robot.getGunHeading()));
        return new Ballistics(adjustedAngle, bPower);
    }

    protected static double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    protected final double powerToKill(double energy) {
        double power = 3.0;
        if (energy <= MIN_DAMAGE) {
            power = 0.1;
        } else if (energy <= 4.0) {
            power = energy / 4.0;
        } else if (energy < MAX_DAMAGE) {
            power = energy / 6.0 + 0.3333333333333333;
        }
        return power;
    }
}

