/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.utils;

import gf.Centaur.targeting.AdvancedGun;
import gf.Centaur.targeting.GunControll;
import gf.Centaur.targeting.HeadOnGun;
import gf.Centaur.targeting.VirtualGun;
import gf.Centaur.utils.ExecutingRobot;
import gf.Centaur.utils.KdTree;
import gf.Centaur.utils.Tools;
import gf.Centaur.utils.VirtualRobot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import robocode.Rules;
import robocode.util.Utils;

public class Wave {
    public static final double MIDDLE = 0.0;
    public static final double NEAR_WALL = 1.0;
    public static final double NEAR_CORNER = 2.0;
    public static final double NEAR_WALL_DIST = 120.0;
    public static final double NEAR_CORNER_DIST = 150.0;
    private static final double GOOD_ANGLE = 5.0;
    private HashMap<GunControll, Double> guns = null;
    private VirtualRobot target;
    private final String targetName;
    private final String execName;
    private final Point2D.Double point;
    private final Point2D.Double targetPos;
    private final double distance;
    private final double bearing;
    private final Double power;
    private final Double velocity;
    private final Double damage;
    private final long time;
    public static final int OWN_SEGMENTATION_LENGTH = 6;
    public static final int ENEMIE_SEGMENTATION_LENGTH = 5;
    private final double[] segmentationLocation;
    private final boolean isReal;
    private boolean isOwn;

    public Wave(ExecutingRobot execRobot, GunControll[] gunArray, KdTree.WeightedSqrEuclid<Double> guessFactors, Double bulletPower, VirtualRobot target, boolean isReal, boolean isOwn) {
        this.time = isOwn ? execRobot.getTime() : execRobot.getTime() - 1L;
        this.target = target;
        this.targetName = target.getName();
        this.execName = execRobot.getName();
        this.point = new Point2D.Double(execRobot.getX(), execRobot.getY());
        this.targetPos = target.getPosition();
        this.distance = this.targetPos.distance(this.point);
        this.bearing = Math.atan2(this.targetPos.getY() - this.point.getY(), this.targetPos.getX() - this.point.getX());
        this.power = bulletPower;
        this.velocity = Rules.getBulletSpeed((double)bulletPower);
        this.damage = Rules.getBulletDamage((double)bulletPower);
        this.isReal = isReal;
        this.isOwn = isOwn;
        this.segmentationLocation = new double[isOwn ? 6 : 5];
        double width = execRobot.getBattleFieldWidth();
        double height = execRobot.getBattleFieldHeight();
        this.segmentationLocation[0] = !(150.0 < this.targetPos.getX() && this.targetPos.getX() < width - 150.0 || 150.0 < this.targetPos.getY() && this.targetPos.getY() < height - 150.0) ? 2.0 : (!(120.0 < this.targetPos.getX() && this.targetPos.getX() < width - 120.0 && 120.0 < this.targetPos.getY() && this.targetPos.getY() < height - 120.0) ? 1.0 : 0.0);
        this.segmentationLocation[1] = target.getVelocity();
        this.segmentationLocation[2] = target.getLateralVelocity(execRobot);
        this.segmentationLocation[3] = this.distance;
        this.segmentationLocation[4] = target.getAcceleration();
        if (isOwn) {
            this.segmentationLocation[5] = isReal ? 1 : 0;
        }
        this.guns = new HashMap();
        GunControll[] gunControllArray = gunArray;
        int n = gunArray.length;
        int n2 = 0;
        while (n2 < n) {
            GunControll gun = gunControllArray[n2];
            double angle = gun instanceof VirtualGun ? ((VirtualGun)gun).getAbsoluteAngle(target, bulletPower, execRobot) : ((AdvancedGun)gun).getAbsoluteAngle(execRobot, guessFactors, bulletPower, target);
            this.guns.put(gun, angle);
            if (isOwn) {
                gun.hasFired(this.targetName);
            }
            ++n2;
        }
    }

    public void draw(Graphics2D g2d, long currentTime, KdTree.WeightedSqrEuclid<Double> enemieGuessFactors) {
        if (this.isOwn && this.isReal) {
            double r = this.getRadius(currentTime);
            g2d.setPaint(Color.green);
            g2d.draw(new Ellipse2D.Double(this.getX() - r, this.getY() - r, 2.0 * r, 2.0 * r));
            for (Map.Entry<GunControll, Double> entry : this.guns.entrySet()) {
                double angle = Tools.toPolar(entry.getValue());
                if (!(entry.getKey() instanceof HeadOnGun)) continue;
                g2d.setPaint(Color.green);
                g2d.draw(new Line2D.Double(this.getX(), this.getY(), this.getX() + Math.cos(angle) * r, this.getY() + Math.sin(angle) * r));
            }
            double maxEscapeAngle = Tools.getMaxEscapeAngle(this.velocity);
            g2d.setPaint(Color.yellow);
            g2d.draw(new Arc2D.Double(this.getX() - r, this.getY() - r, 2.0 * r, 2.0 * r, Math.toDegrees(Tools.toPolar(this.bearing) - maxEscapeAngle) - 90.0, Math.toDegrees(2.0 * maxEscapeAngle), 0));
        } else if (!this.isOwn) {
            double r = this.getRadius(currentTime);
            double a = 0.0;
            while (a < Math.PI * 2) {
                double danger = Math.min(this.getDanger(a + Math.toRadians(0.5), enemieGuessFactors), 1.0);
                if (danger > 0.0) {
                    g2d.setPaint(new Color((float)danger, 0.0f, (float)(1.0 - danger)));
                    g2d.draw(new Arc2D.Double(this.point.getX() - r, this.point.getY() - r, 2.0 * r, 2.0 * r, Math.toDegrees(a) - 90.0, 1.0, 0));
                }
                a += Math.toRadians(1.0);
            }
        }
    }

    public double[] getSegmentationLocation() {
        return this.segmentationLocation;
    }

    public double getGuessFactor() {
        return this.getGuessFactor(this.target.getX(), this.target.getY());
    }

    public double getGuessFactor(double pointX, double pointY) {
        double maxEscapeAngle = Tools.getMaxEscapeAngle(this.velocity);
        double x = pointX - this.getX();
        double y = pointY - this.getY();
        double targetBearing = Utils.normalRelativeAngle((double)Math.atan2(y, x));
        return Utils.normalRelativeAngle((double)(this.bearing - targetBearing)) / maxEscapeAngle;
    }

    public double getDanger(double angle, KdTree.WeightedSqrEuclid<Double> enemieGuessFactors) {
        double sum = 0.0;
        for (double gunAngle : this.guns.values()) {
            sum += Math.max(1.0 - Math.abs(Utils.normalRelativeAngle((double)(angle - gunAngle))) * 32.0 / Math.PI, 0.0) * 0.5;
        }
        for (KdTree.Entry guessFactor : enemieGuessFactors.nearestNeighbor(this.segmentationLocation, 5, false)) {
            double absAngle = Tools.toAbsolute(this.bearing - (Double)guessFactor.value * Tools.getMaxEscapeAngle(this.velocity));
            sum += Math.max(1.0 - Math.abs(Utils.normalRelativeAngle((double)(angle - absAngle))) * 32.0 / Math.PI, 0.0);
        }
        return sum;
    }

    public Vector<GoodGun> getGoodGuns() {
        double x = this.target.getX() - this.getX();
        double y = this.target.getY() - this.getY();
        double targetBearing = Utils.normalAbsoluteAngle((double)Tools.toAbsolute(Math.atan2(y, x)));
        Vector<GoodGun> goodGuns = new Vector<GoodGun>();
        for (Map.Entry<GunControll, Double> entry : this.guns.entrySet()) {
            double angleDiff = Math.abs(targetBearing - entry.getValue());
            if (!(angleDiff < Math.toRadians(5.0))) continue;
            goodGuns.add(new GoodGun(entry.getKey(), angleDiff));
        }
        return goodGuns;
    }

    public String getExecName() {
        return this.execName;
    }

    public double getRadius(long currentTime) {
        return this.velocity * (double)(currentTime - this.time);
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Point2D.Double getPoint() {
        return this.point;
    }

    public Point2D.Double getTargetPosition() {
        return this.targetPos;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getPower() {
        return this.power;
    }

    public double getDamage() {
        return this.damage;
    }

    public long getTime() {
        return this.time;
    }

    public double getX() {
        return this.point.getX();
    }

    public double getY() {
        return this.point.getY();
    }

    public boolean isReal() {
        return this.isReal;
    }

    public boolean isOwn() {
        return this.isOwn;
    }

    public static class GoodGun {
        private GunControll gun;
        private double angleDiff;

        public GoodGun(GunControll gun, double angleDiff) {
            this.gun = gun;
            this.angleDiff = angleDiff;
        }

        public GunControll getGun() {
            return this.gun;
        }

        public double getAngleDifference() {
            return this.angleDiff;
        }
    }
}

