/*
 * Decompiled with CFR 0.152.
 */
package fowl3628800;

import fowl3628800.Coordinate;
import fowl3628800.Enemy;
import fowl3628800.EnemyCollection;
import fowl3628800.ModularBot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class EnemyImpl
implements Enemy {
    private String m_name = null;
    private double m_energy = 0.0;
    private double m_velocity = 0.0;
    private long m_time = 0L;
    private double m_angularVelocity = 0.0;
    private double m_damageDoneByMe = 0.0;
    private double m_damageDoneToMe = 0.0;
    private Coordinate m_position = null;
    private double m_heading = 0.0;
    private double m_bearing = 0.0;
    private double m_absBearing = 0.0;
    private boolean m_dead = false;

    private EnemyImpl() {
    }

    @Override
    public void setName(String in_newName) {
        this.m_name = in_newName;
    }

    @Override
    public void setEnergy(double in_newEnergy) {
        this.m_energy = in_newEnergy;
    }

    @Override
    public void setVelocity(double in_newVelocity) {
        this.m_velocity = in_newVelocity;
    }

    @Override
    public void setTime(long in_newTime) {
        this.m_time = in_newTime;
    }

    @Override
    public void setAngularVelocity(double in_newAngularVelocity) {
        this.m_angularVelocity = in_newAngularVelocity;
    }

    @Override
    public void setDamageDoneByMe(double in_newDamageDoneByMe) {
        this.m_damageDoneByMe = in_newDamageDoneByMe;
    }

    @Override
    public void setDamageDoneToMe(double in_newDamageDoneToMe) {
        this.m_damageDoneToMe = in_newDamageDoneToMe;
    }

    @Override
    public void setPosition(Coordinate in_newPosition) {
        this.m_position = in_newPosition;
    }

    @Override
    public void setHeading(double in_newHeading) {
        this.m_heading = in_newHeading;
    }

    @Override
    public void setBearing(double in_newBearing) {
        this.m_bearing = in_newBearing;
    }

    @Override
    public void setIfDead(boolean dead) {
        this.m_dead = dead;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public double getEnergy() {
        return this.m_energy;
    }

    @Override
    public double getVelocity() {
        return this.m_velocity;
    }

    @Override
    public long getTime() {
        return this.m_time;
    }

    @Override
    public double getAngularVelocity() {
        return this.m_angularVelocity;
    }

    @Override
    public double getDamageDoneByMe() {
        return this.m_damageDoneByMe;
    }

    @Override
    public double getDamageDoneToMe() {
        return this.m_damageDoneToMe;
    }

    @Override
    public Coordinate getPosition() {
        return this.m_position;
    }

    @Override
    public double getHeading() {
        return this.m_heading;
    }

    @Override
    public double getBearing() {
        return this.m_bearing;
    }

    @Override
    public boolean isDead() {
        return this.m_dead;
    }

    public static final Enemy createEnemy(ScannedRobotEvent in_event, ModularBot bot, EnemyCollection col) {
        EnemyImpl out_enemy = new EnemyImpl();
        out_enemy.setName(in_event.getName());
        out_enemy.setEnergy(in_event.getEnergy());
        out_enemy.setVelocity(in_event.getVelocity());
        out_enemy.setTime(in_event.getTime());
        out_enemy.setDamageDoneByMe(col == null ? 0.0 : col.getDamageDoneByMe());
        out_enemy.setDamageDoneToMe(col == null ? 0.0 : col.getDamageDoneToMe());
        if (col != null) {
            double diffHeading = in_event.getHeading() - col.getHeading();
            diffHeading = Utils.normalRelativeAngleDegrees((double)diffHeading);
            double diffTime = in_event.getTime() - col.getTime();
            out_enemy.setAngularVelocity(col.getAngularVelocity() == 0.0 ? diffHeading / diffTime : (col.getAngularVelocity() + diffHeading / diffTime) / 2.0);
        } else {
            out_enemy.setAngularVelocity(0.0);
        }
        double absBearing_deg = (in_event.getBearing() + bot.getHeading()) % 360.0;
        double x = Math.sin(Math.toRadians(absBearing_deg)) * in_event.getDistance() + bot.getX();
        double y = Math.cos(Math.toRadians(absBearing_deg)) * in_event.getDistance() + bot.getY();
        out_enemy.setPosition(new Coordinate(x, y));
        out_enemy.setHeading(in_event.getHeading());
        out_enemy.setBearing(in_event.getBearing());
        out_enemy.setAbsBearing(absBearing_deg);
        return out_enemy;
    }

    @Override
    public double getAbsBearing() {
        return this.m_absBearing;
    }

    @Override
    public void setAbsBearing(double absBearing) {
        this.m_absBearing = absBearing;
    }
}

