/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import lazarecki.data.DataSegmentWave;
import lazarecki.robot.ModularRobot;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.AbstractDataModule;
import lazarecki.robot.strategy.StrategicModule;
import lazarecki.util.RoboUtils;
import lazarecki.wave.Wave;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GuessFactorTargetingModule
extends StrategicModule {
    private AbstractDataModule dataModule;
    private List<DataSegmentWave> waves;
    private DataSegmentWave waveToFire;

    public GuessFactorTargetingModule(AbstractDataModule dataModule) {
        this.dataModule = dataModule;
        this.waves = new LinkedList<DataSegmentWave>();
    }

    public List<DataSegmentWave> getWaves() {
        return this.waves;
    }

    public AbstractDataModule getDataModule() {
        return this.dataModule;
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        RobotInfo myInfo = new RobotInfo(this.getRobot());
        RobotInfo target = new RobotInfo(new Point2D.Double(event.getBullet().getX(), event.getBullet().getY()), myInfo.getHeadingRadians(), myInfo.getVelocity(), myInfo.getEnergy(), myInfo.getTime(), myInfo.getBattleFieldWidth(), myInfo.getBattleFieldHeight());
        DataSegmentWave wave = this.getClosestWave(target);
        if (wave == null) {
            return;
        }
        wave.setValid(false);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        RobotInfo myInfo = new RobotInfo(this.getRobot());
        RobotInfo targetInfo = new RobotInfo(event, this.getRobot());
        this.processWaves(targetInfo);
        this.fireWave(myInfo, targetInfo);
    }

    @Override
    public void onRun() {
        if (this.waveToFire == null) {
            return;
        }
        ModularRobot robot = this.getRobot();
        double bodyTurn = RoboUtils.limit(-RoboUtils.maxTurnRate(robot.getVelocity()), robot.getTurnRemainingRadians(), RoboUtils.maxTurnRate(robot.getVelocity()));
        double gunOffset = Utils.normalRelativeAngle((double)(this.waveToFire.getAbsoluteBestFireAngle() - robot.getGunHeadingRadians()));
        robot.setTurnGunRightRadians(gunOffset);
        if (robot.getGunHeat() == 0.0 && robot.getFirePower() != 0.0 && Math.abs(gunOffset - bodyTurn) <= Rules.GUN_TURN_RATE_RADIANS) {
            robot.addCustomEvent(new FireBullet(this.waveToFire));
        }
        this.waveToFire = null;
    }

    @Override
    public void onCustomEvent(CustomEvent event) {
        if (!event.getCondition().getName().equals("FireBullet")) {
            return;
        }
        ModularRobot robot = this.getRobot();
        FireBullet fireBullet = (FireBullet)event.getCondition();
        RobotInfo shooter = new RobotInfo(robot);
        DataSegmentWave wave = new DataSegmentWave(shooter, fireBullet.getWave().getTarget(), fireBullet.getWave().getFirePower(), fireBullet.getWave().getDataSegment(), fireBullet.getWave().getExtrapolator());
        robot.setFireBullet(wave.getFirePower());
        this.getWaves().add(wave);
        robot.removeCustomEvent(fireBullet);
    }

    protected DataSegmentWave getClosestWave(RobotInfo surfer) {
        double distance = Double.MAX_VALUE;
        DataSegmentWave enemyWave = null;
        for (DataSegmentWave wave : this.waves) {
            double waveDistance = Math.abs(surfer.distance(wave.getShooter()) - wave.getDistanceTraveled(surfer.getTime()));
            if (!(waveDistance < distance)) continue;
            enemyWave = wave;
            distance = waveDistance;
        }
        return enemyWave;
    }

    protected void processWaves(RobotInfo target) {
        ListIterator<DataSegmentWave> waveIt = this.waves.listIterator();
        while (waveIt.hasNext()) {
            Wave bullet = waveIt.next();
            if (!bullet.isValid()) {
                waveIt.remove();
                continue;
            }
            if (!bullet.isTargetHit(target)) continue;
            bullet.logTargetHit(target, 1.0);
            bullet.setValid(false);
        }
    }

    protected void fireWave(RobotInfo shooter, RobotInfo target) {
        ModularRobot robot = this.getRobot();
        this.waveToFire = new DataSegmentWave(shooter, target, robot.getFirePower(), this.getDataModule().getDataSegment(), this.getDataModule().getExtrapolator());
    }

    private class FireBullet
    extends Condition {
        public static final String NAME = "FireBullet";
        private DataSegmentWave wave;

        public FireBullet(DataSegmentWave wave) {
            this.wave = wave;
        }

        public DataSegmentWave getWave() {
            return this.wave;
        }

        public String getName() {
            return NAME;
        }

        public boolean test() {
            return true;
        }
    }
}

