/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.DownstreamComponent;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.UpstreamComponent;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.connection.AdjacencyListConnection;
import dmonner.xlbp.connection.AdjacencyMatrixConnection;
import dmonner.xlbp.connection.LayerConnection;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.UpstreamLayer;
import dmonner.xlbp.layer.WeightReceiverLayer;
import dmonner.xlbp.layer.WeightSenderLayer;
import dmonner.xlbp.layer.WeightedLayer;
import java.util.LinkedList;

public class WeightBank
implements Component {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final WeightSenderLayer wsend;
    private final WeightReceiverLayer wrecv;
    private WeightUpdaterType wut;
    private WeightInitializer win;
    private final UpstreamLayer upstream;
    private final DownstreamLayer downstream;
    private Boolean truncate;
    private boolean built;

    public WeightBank(String name, UpstreamLayer upstream, DownstreamLayer downstream, WeightInitializer win, WeightUpdaterType wut) {
        this.name = name;
        this.win = win;
        this.wut = wut;
        this.upstream = upstream;
        this.downstream = downstream;
        this.wsend = new WeightSenderLayer(name + "WeightSender", upstream.size());
        this.wrecv = new WeightReceiverLayer(name + "WeightReceiver", downstream.size());
        downstream.addUpstream(this.wrecv);
        this.wsend.addUpstream(upstream);
        this.installConnection();
    }

    public WeightBank(WeightBank that, NetworkCopier copier) {
        this.name = copier.getCopyNameFrom(that);
        this.win = that.win;
        this.wut = that.wut;
        this.truncate = that.truncate;
        this.built = that.built;
        this.upstream = copier.getCopyOf(that.upstream);
        this.downstream = copier.getCopyOf(that.downstream);
        this.wsend = copier.getCopyOf(that.wsend);
        this.wrecv = copier.getCopyOf(that.wrecv);
    }

    @Override
    public void activateTest() {
        this.wrecv.activateTest();
    }

    @Override
    public void activateTrain() {
        this.wrecv.activateTrain();
    }

    @Override
    public void build() {
        if (!this.built) {
            this.wsend.build();
            this.wrecv.build();
            this.checkForUpstreamWeights();
            this.built = true;
        }
    }

    private void checkForUpstreamWeights() {
        if (this.truncate == null) {
            this.truncate = true;
            LinkedList<UpstreamComponent> q = new LinkedList<UpstreamComponent>();
            q.add(this.wsend.getUpstream());
            while (!q.isEmpty()) {
                UpstreamComponent current = (UpstreamComponent)q.remove();
                if (current instanceof WeightedLayer) {
                    this.truncate = false;
                    break;
                }
                if (!(current instanceof DownstreamLayer)) continue;
                DownstreamComponent currDown = (DownstreamComponent)((Object)current);
                for (int i = 0; i < currDown.nUpstream(); ++i) {
                    q.add(currDown.getUpstream(i));
                }
            }
        }
    }

    @Override
    public void clear() {
        this.clearActivations();
        this.clearEligibilities();
        this.clearResponsibilities();
    }

    @Override
    public void clearActivations() {
        this.wrecv.clearActivations();
    }

    @Override
    public void clearEligibilities() {
        this.wrecv.clearEligibilities();
    }

    @Override
    public void clearResponsibilities() {
        this.wrecv.clearResponsibilities();
    }

    @Override
    public int compareTo(Component that) {
        return this.name.compareTo(that.getName());
    }

    @Override
    public WeightBank copy(NetworkCopier copier) {
        return new WeightBank(this, copier);
    }

    @Override
    public WeightBank copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        WeightBank copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
    }

    public LayerConnection getConnection() {
        return this.wrecv.getConnection();
    }

    public DownstreamLayer getDownstream() {
        return this.downstream;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UpstreamLayer getUpstream() {
        return this.upstream;
    }

    public WeightReceiverLayer getWeightInput() {
        return this.wrecv;
    }

    public WeightSenderLayer getWeightOutput() {
        return this.wsend;
    }

    protected void installConnection() {
        LayerConnection conn = this.makeConnection();
        conn.setWeightInitializer(this.win);
        conn.setWeightUpdater(this.wut);
        this.wrecv.removeConnection();
        this.wrecv.setConnection(conn);
    }

    @Override
    public boolean isBuilt() {
        return this.built;
    }

    protected LayerConnection makeConnection() {
        if (this.win.fullConnectivity()) {
            return new AdjacencyMatrixConnection(this.name, this.wrecv, this.wsend);
        }
        return new AdjacencyListConnection(this.name, this.wrecv, this.wsend);
    }

    @Override
    public int nWeights() {
        return this.wrecv.getConnection().nWeights();
    }

    @Override
    public boolean optimize() {
        this.wsend.optimize();
        this.wrecv.optimize();
        return true;
    }

    @Override
    public void processBatch() {
        this.wrecv.processBatch();
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
        this.win = win;
        this.installConnection();
    }

    @Override
    public void setWeightUpdaterType(WeightUpdaterType wut) {
        this.wut = wut;
        this.installConnection();
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showIntermediate()) {
            if (sb.showName()) {
                sb.indent();
                sb.append(this.name);
                sb.append(" : ");
                sb.append(this.getClass().getSimpleName());
                sb.appendln();
            }
            if (sb.showExtra()) {
                sb.indent();
                sb.append("Truncated? ");
                sb.append(String.valueOf(this.truncate));
                sb.appendln();
            }
            sb.pushIndent();
            this.wrecv.toString(sb);
            this.wsend.toString(sb);
            sb.popIndent();
        } else {
            this.wrecv.getConnection().toString(sb);
        }
    }

    @Override
    public String toString(String show) {
        NetworkStringBuilder sb = new NetworkStringBuilder(show);
        this.toString(sb);
        return sb.toString();
    }

    public void truncate(boolean truncate) {
        this.truncate = truncate;
    }

    @Override
    public void unbuild() {
        this.built = false;
        this.wsend.unbuild();
        this.wrecv.unbuild();
    }

    @Override
    public void updateEligibilities() {
        this.wrecv.updateEligibilities();
    }

    @Override
    public void updateResponsibilities() {
        this.wrecv.updateResponsibilities();
        if (!this.truncate.booleanValue()) {
            this.wsend.updateResponsibilities();
        }
    }

    @Override
    public void updateWeights() {
        this.wrecv.updateWeights();
    }
}

