/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

public class ArrayQueue<T> {
    private T[] q;
    private int head;
    private int size;
    private int capacity;

    public ArrayQueue() {
        this(0);
    }

    public ArrayQueue(int capacity) {
        this.q = new Object[capacity];
        this.head = 0;
        this.size = 0;
        this.capacity = capacity;
    }

    public ArrayQueue(T[] full) {
        this.fill(full);
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        this.head = 0;
        this.size = 0;
    }

    public void fill(T[] full) {
        this.q = full;
        this.head = 0;
        this.size = this.q.length;
        this.capacity = this.q.length;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size >= this.capacity;
    }

    public T peek() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot peek -- queue is empty.");
        }
        return this.q[this.head];
    }

    public T peek(int idx) {
        if (idx < 0 || idx >= this.size) {
            throw new IllegalStateException("Cannot peek at " + idx + " -- not enough elements.");
        }
        return this.q[(this.head + idx) % this.capacity];
    }

    public T pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot pop -- queue is empty.");
        }
        T rv = this.q[this.head];
        this.head = (this.head + 1) % this.capacity;
        --this.size;
        return rv;
    }

    public void popN(int n) {
        if (this.size < n) {
            throw new IllegalStateException("Cannot pop " + n + " -- not enough elements.");
        }
        this.head = (this.head + n) % this.capacity;
        this.size -= n;
    }

    public void push(T elem) {
        if (this.isFull()) {
            throw new IllegalStateException("Cannot push -- queue is full.");
        }
        int next = (this.head + this.size) % this.capacity;
        this.q[next] = elem;
        ++this.size;
    }

    public int size() {
        return this.size;
    }
}

