//--------------------------------------------------------------------------
// $Id: EnemyState.java,v 1.1 2003/08/29 09:16:22 erning Exp $
//--------------------------------------------------------------------------
// Copyright (c) 2000-2003 Dragon Software Corp. All rights reserved.
//
// Please refer to COPYRIGHT for notices regarding the confidential
// and proprietary nature of this source code.
//--------------------------------------------------------------------------

package net.dragonsoft.robocoding;

public class EnemyState
{
    // all angles are radians

    public double energy;
    public double heading;
    public double bearing;
    public double velocity;
    public double distance;

    public double angle;        // the absolute angle from (myX, myY) to (x, y)
    public double x;
    public double y;

    public double velocityChange;
    public double headingChange;
    public double energyChange;

    public double myEnergy;
    public double myHeading;
    public double myVelocity;
    public double myX;
    public double myY;

    public long time;

    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        sb.append("EnemyState: ");

        sb.append("[energy=").append(Math.round(energy * 10) / 10).append("]");
        sb.append("[heading=").append(Math.round(Math.toDegrees(heading))).append("]");
        sb.append("[bearing=").append(Math.round(Math.toDegrees(bearing))).append("]");
        sb.append("[velocity=").append(Math.round(velocity * 10) / 10).append("]");
        sb.append("[distance=").append(Math.round(distance)).append("]");

        sb.append("[angle=").append(Math.round(Math.toDegrees(angle))).append("]");
        sb.append("[x=").append(Math.round(x)).append("]");
        sb.append("[y=").append(Math.round(y)).append("]");
        sb.append("[velocityChange=").append(Math.round(velocityChange * 10) / 10).append("]");
        sb.append("[headingChange=").append(Math.round(headingChange * 10) / 10).append("]");

        sb.append("[time=").append(time).append("]");

        sb.append("[myEnergy=").append(Math.round(myEnergy * 10) / 10).append("]");
        sb.append("[myHeading=").append(Math.round(Math.toDegrees(myHeading))).append("]");
        sb.append("[myVelocity=").append(Math.round(myVelocity * 10) / 10).append("]");
        sb.append("[myX=").append(Math.round(myX)).append("]");
        sb.append("[myY=").append(Math.round(myY)).append("]");

        return sb.toString();
    }
}
