package zyx.mega.bot;

import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Math.PI;
import static java.lang.Math.abs;
import static java.lang.Math.cos;
import static java.lang.Math.max;
import static java.lang.Math.min;
import static java.lang.Math.sin;
import static robocode.Rules.MAX_BULLET_POWER;
import static robocode.Rules.MIN_BULLET_POWER;
import static zyx.mega.utils.Config._mc_;
import static zyx.mega.utils.Config._pc_;
import static zyx.mega.utils.Config._raiko_fire_power_;
import static zyx.mega.utils.Config._tc_;
import static zyx.mega.utils.Config.movement_enabled_;
import static zyx.mega.utils.Config.targeting_enabled_;
import static zyx.mega.utils.Range.CapLowHigh;
import static zyx.mega.utils.RollingAverage.Roll;
import static zyx.mega.utils.TurnHandler.Move;
import static zyx.mega.utils.TurnHandler._1v1_;
import static zyx.mega.utils.TurnHandler._melee_;
import static zyx.mega.utils.TurnHandler.exact_time_;
import static zyx.mega.utils.TurnHandler.handler_;
import static zyx.mega.utils.TurnHandler.last_death_;
import static zyx.mega.utils.TurnHandler.me_;
import static zyx.mega.utils.TurnHandler.minimum_risk_;
import static zyx.mega.utils.TurnHandler.num_enemies_;
import static zyx.mega.utils.TurnHandler.others_;
import static zyx.mega.utils.TurnHandler.robot_;
import static zyx.mega.utils.TurnHandler.time_;

import java.util.ArrayList;

import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import zyx.mega.movement.WaveSurfing;
import zyx.mega.targeting.VGunSystem;
import zyx.mega.utils.Range;
import zyx.mega.utils.RollingAverage;
import zyx.mega.utils.Snapshot;

public class Enemy extends Bot {
  private static final int NONE = 0;
  private static final int MY_FAULT = 1;
  private static final int HIS_FAULT = 2;
  
  private static final double DESIRE_STRENGTH = 0.85;
  private static final double CURRENT_STRENGTH = 1 - DESIRE_STRENGTH;
  
  private static ArrayList<Enemy> enemies_ = new ArrayList<Enemy>();
  public static Enemy Find(String name) {
    for (Enemy enemy : enemies_) if ( enemy.name_.equals(name) ) {
      return enemy;
    }
    Enemy enemy = new Enemy(name);
    enemies_.add(enemy);
    System.out.println("Registering new enemy: " + name);
    return enemy;
  }
  public static ArrayList<Enemy> Phonebook() {
    return enemies_;
  }
  /* Melee Target handling */
  public static Enemy closest_;
  public static Enemy last_seen_;
  public static MeleeEnemy alive_enemies_[];
  public static void StaticInit() {
    if ( alive_enemies_ == null ) {
      alive_enemies_ = new MeleeEnemy[num_enemies_];
      for ( int i = 0; i < num_enemies_; ++i ) alive_enemies_[i] = new MeleeEnemy();
    }
  }
  public static void PreMeleeRun() {
    last_seen_ = closest_ = null;
    int i = 0;
    for ( Enemy enemy : enemies_ ) if ( !enemy.dead_ ) {
      MeleeEnemy menemy = alive_enemies_[i++].SetEnemy(enemy);
      if ( closest_ == null || enemy.distance_ < closest_.distance_ ) closest_ = enemy;
      if ( last_seen_ == null || enemy.scan_time_ < closest_.scan_time_ ) last_seen_ = enemy;
      for ( int k = 0, j = 1; j < i; ++k, ++j ) {
        double d = enemy.distanceSq(alive_enemies_[k].bot_);
        if ( d < menemy.min_distance_ ) {
          menemy.min_distance_ = d;
          menemy.target_ = alive_enemies_[k].bot_;
        }
        if ( d < alive_enemies_[k].min_distance_ ) {
          alive_enemies_[k].min_distance_ = d;
          alive_enemies_[k].target_ = menemy.bot_;
        }
      }
    }
    for ( int e = 0; e < others_; ++e ) alive_enemies_[e].min_distance_ *= 0.8;
  }

  public String toString() {
    //return super.toString();
    return name_;
  }
  
  public String name_;
  public long scan_time_;
  public double distance_;
  public double my_lateral_velocity_;
  public double my_approaching_velocity_;
  public int my_direction_;
  public VGunSystem gun_;
  public WaveSurfing wave_surfing_;
  public RollingAverage avg_fire_power_;
  public RollingAverage accuracy_;

  public Snapshot _now_;
  public Snapshot _1ago_;
  public Snapshot _2ago_;
  public double damage_taken_;
  public double damage_given_;
  public int orbit_direction_;
  public boolean dead_;
  public int rams_;
  public boolean rammer_ = true;
  public double fire_power_;
  private int hit_robot_;
  public long last_hit_time_;
  public double last_hit_power_;
  public long scans_difference_;
  public boolean bullet_catching_;
  public long time_since_shot_;
  private long last_shot_;
  public double energy_ratio_;
  public double desired_distance_;
  public double melee_gun_scores_[];

  public Enemy(String name) {
    name_ = name;
    //log_ = new ArrayList<Snapshot>();
    if ( movement_enabled_ ) wave_surfing_ = new WaveSurfing(this);
    //stop_and_go_ = new StopAndGo(this);
    //anti_rammer_ = new AntiRammerMovement(this);
    if ( targeting_enabled_ ) gun_ = new VGunSystem(this);
    avg_fire_power_ = new RollingAverage(3);
    accuracy_ = new RollingAverage(101);
    orbit_direction_ = 1;
    rams_ = 0;
    Init();
    if ( _melee_ ) {
      melee_gun_scores_ = new double[3];
      melee_gun_scores_[0] = 1;
      melee_gun_scores_[1] = 1.05;
      melee_gun_scores_[2] = 1;
    }
  }
  public void Init() {
    //SetPoint(WIDTH / 2 + random() * 18 - 9, HEIGHT / 2 + random() * 18 - 9);
    time_running_ = time_stopped_ = 0;
    direction_ = my_direction_ = 1;
    _now_ = _1ago_ = _2ago_ = null;
    energy_ = 100;
    dead_ = false;
    if ( movement_enabled_ ) wave_surfing_.Init();
    if ( targeting_enabled_ ) gun_.Init();
    bullet_catching_ = movement_enabled_ && targeting_enabled_;
    bullet_catching_ = false;
  }
  public void onBulletHit(BulletHitEvent event) {
    Bullet bullet = event.getBullet();
    energy_ -= Rules.getBulletDamage(bullet.getPower());
    damage_given_ += Rules.getBulletDamage(bullet.getPower());
    if ( targeting_enabled_ && _1v1_ ) gun_.onBulletHit(bullet);
  }
  public void onBulletHitBullet(long time, Bullet bullet, zyx.mega.geometry.Bullet hit_bullet) {
    if ( movement_enabled_ && _1v1_ ) {
      wave_surfing_.onHitByBullet(time - 1, hit_bullet, false);
    }
    if ( targeting_enabled_ && _1v1_ ) gun_.onBulletHitBullet(bullet);
  }
  public void onHitByBullet(HitByBulletEvent event) {
    energy_ += Rules.getBulletHitBonus(event.getPower());
    if ( movement_enabled_ && _1v1_ ) {
      if ( bullet_catching_ ) System.out.println("Stop catching bullets, he hitted me");
      bullet_catching_ = false;
      wave_surfing_.onHitByBullet(time_ - 1, new zyx.mega.geometry.Bullet(event.getBullet()), true);
    }
    accuracy_.Roll(1, 1);
    damage_taken_ += Rules.getBulletDamage(event.getPower());
    last_hit_power_ = event.getPower();
    last_hit_time_ = time_;
  }
  public void onHitRobot(HitRobotEvent event) {
    if ( !event.isMyFault() ) {
      hit_robot_ = MY_FAULT;
    } else {
      ++rams_;
      hit_robot_ = HIS_FAULT;
    }
  }
  public void onHitWall(HitWallEvent event) {
  }
  public void onRobotDeath(RobotDeathEvent event) {
    dead_ = true;
    if ( this == closest_ ) closest_ = null;
    //Log();
    if ( others_ == 0 ) {
      if ( targeting_enabled_ ) gun_.onScannedRobot();
      KeepSurfing();
      while ( true ) {
        robot_.setFireBullet(Rules.MIN_BULLET_POWER); robot_.turnRight(60);
        robot_.setFireBullet(Rules.MIN_BULLET_POWER); robot_.turnLeft(60);
      }
    } else if ( others_ == 5 && minimum_risk_ != null ) minimum_risk_.target_ = null;
  }
  private void KeepSurfing() {
    if ( movement_enabled_ ) {
      robot_.setTurnGunRightRadians(POSITIVE_INFINITY);
      if ( movement_enabled_ ) while ( wave_surfing_.HaveWaves() ) {
        handler_.Update();
        wave_surfing_.onScannedRobot(false, 0);
        if ( me_.energy_ > 16 ) robot_.setFire(Rules.MIN_BULLET_POWER);
        robot_.execute();
      }
    }
  }
  public void onScannedRobot(ScannedRobotEvent event) {
    if ( bullet_catching_ && _1v1_ ) {
      bullet_catching_ = event.getEnergy() > 50 ;
      if ( !bullet_catching_ ) System.out.println("Stop catching bullets, time to kill him");
    }
    if ( _1ago_ == null ) {
      gun_heat_ = 3.1 - time_ * 0.1;
    }
    if ( time_ < 30 ) time_since_shot_ = 0;
    if ( !_1v1_ ) {
      gun_heat_ = 0.2;
      time_since_shot_ = 0;
    }
    double energy_drop = energy_ - event.getEnergy();
    double last_velocity = velocity_;
    scans_difference_ = time_ - scan_time_;
    long elapsed = scans_difference_;
    scan_time_ = time_;
    bearing_ = Utils.normalAbsoluteAngle(me_.heading_ + event.getBearingRadians());
    distance_ = event.getDistance();
    energy_ = event.getEnergy();
    heading_ = event.getHeadingRadians();
    velocity_ = event.getVelocity();
    gun_heat_ = Range.CapLow(gun_heat_ - robot_.getGunCoolingRate(), 0);
    ProjectPoint(me_, bearing_, distance_);
    lateral_velocity_ = velocity_ * sin(heading_ - bearing_);
    if ( velocity_ != 0 ) direction_ = lateral_velocity_ < 0 ? -1 : 1;
    my_lateral_velocity_ = me_.velocity_ * sin(event.getBearingRadians());
    if ( me_.velocity_ != 0 ) my_direction_ = my_lateral_velocity_ < 0 ? -1 : 1;
    approaching_velocity_ = velocity_ * cos(heading_ - bearing_);
    my_approaching_velocity_ = me_.velocity_ * cos(me_.heading_ - bearing_ + PI);
    energy_ratio_ = energy_ / me_.energy_;

    double dodge_distance = min(WIDTH, HEIGHT) * 0.85;
    desired_distance_ = 400;
    if ( time_since_shot_ > 150 ) desired_distance_ = 0;
    else if ( time_since_shot_ > 80 && energy_ratio_ < 1 - 1e-5 ) desired_distance_ = 100;
    else if ( time_since_shot_ > 40 && energy_ratio_ < 1 - 1e-5 ) desired_distance_ = 200;
    else if ( energy_ratio_ > 4 ) desired_distance_ = dodge_distance;
    else if ( energy_ratio_ > 1 - 1e-5 && me_.energy_ < 2 ) desired_distance_ = dodge_distance;
    else if ( energy_ratio_ < 0.2 ) desired_distance_ = 300;
    //System.out.println("Desired: " + desired_distance_);
    if ( desired_distance_ > 0 ) desired_distance_ = DESIRE_STRENGTH * desired_distance_ + CURRENT_STRENGTH * distance_;
    //System.out.println("Real target: " + desired_distance_);

    //System.out.println("Desired distance: " + desired_distance_);

    FinishUpdate();
    UpdateFirePower();
    CreateSnapshot(elapsed);
    
    if ( movement_enabled_ && _1v1_ ) {
      wave_surfing_.PrintStats();
      if ( _1ago_ != null && velocity_ == 0 ) {
        if ( hit_robot_ == NONE ) {
          double wall_damage = max(0, abs(last_velocity) / 2 - 1);
          energy_drop -= wall_damage;
        } else {
          double hit_damage = 0.6;
          if ( hit_robot_ == MY_FAULT && last_velocity * cos(heading_ - bearing_) < 0 ) {
            hit_damage += 0.6;
          }
          energy_drop -= hit_damage;
        }
      }
      boolean new_shot = gun_heat_ < robot_.getGunCoolingRate() * 2 &&
        energy_drop + 1e-9 > Rules.MIN_BULLET_POWER && energy_drop - 1e-9 < Rules.MAX_BULLET_POWER;
      if ( new_shot /*&& time_ >= last_death_ + 7*/) {
        avg_fire_power_.Roll(energy_drop, 1);
        gun_heat_ = 1 + energy_drop / 5 - robot_.getGunCoolingRate();
        last_shot_ = time_ - 1;
      }
      time_since_shot_ = time_ - last_shot_;
      if ( !rammer_ ) {
        rammer_ = (double)rams_ / exact_time_ > 0.1;
        if ( rammer_ ) System.out.println("Enemy is a RAMMER!!");
      }
      if ( energy_ == 0 && !wave_surfing_.HaveWaves() ) {
        //TODO: should this be here??
        Move(1000, bearing_);
      }
      wave_surfing_.onScannedRobot(new_shot, energy_drop);
    }
    if ( targeting_enabled_ && _1v1_ ) gun_.onScannedRobot();
    hit_robot_ = NONE;
  }
  private void UpdateFirePower() {
    if ( _tc_ ) fire_power_ = 3;
    else if ( _pc_) fire_power_ = 0.5;
    else if ( _mc_ ) fire_power_ = 0;
    else if ( _raiko_fire_power_ ) SetRaikoFirePower();
    else if ( bullet_catching_ ) fire_power_ = 0;
    else if ( energy_ == 0 ) {
      if ( movement_enabled_ && !wave_surfing_.HaveWaves() ) fire_power_ = 0;
      else fire_power_ = MIN_BULLET_POWER;
    } else {
      if ( energy_ + 1e-9 < 4 ) {
        fire_power_ = energy_ / 4 + 1e-5;
      } else {
        fire_power_ = max(1 + 1e-9, (energy_ + 2) / 6);
      }
      fire_power_ = max(MIN_BULLET_POWER, fire_power_);
      if ( distance_ < 80 ) {
        fire_power_ = min(fire_power_, 3);
      } else {
        boolean blast = distance_ < 120;
        //blast = blast || (me_.energy_ > 50 && energy_ < me_.energy_ - 3);
        //blast = blast || (me_.energy_ > 35 && energy_ < me_.energy_ - 12);
        if ( blast ) {
          fire_power_ = min(fire_power_, 3);
        } else {
          if ( gun_.BestRating() > 0.4 && distance_ < 500 ) fire_power_ = min(fire_power_, 3);
          else if ( gun_.BestRating() > 0.3 && distance_ < 350 ) fire_power_ = min(fire_power_, 3);
          else if ( gun_.BestRating() > 0.2 && distance_ < 200 ) fire_power_ = min(fire_power_, 3);
          else fire_power_ = min(fire_power_, 1.9);
        }
        fire_power_ = min(fire_power_, me_.energy_ / 4);
        if ( _melee_ && energy_ratio_ > 1.1 ) fire_power_ /= 2;
        //if ( energy_ratio_ < 1 && me_.energy_ < 50 && energy_ > me_.energy_ - fire_power_ ) fire_power_ = me_.energy_ - energy_ - 0.5;
        if ( me_.energy_ - fire_power_ < MIN_BULLET_POWER && distance_ > 70 ) fire_power_ = 0;
        else fire_power_ = CapLowHigh(fire_power_, MIN_BULLET_POWER, MAX_BULLET_POWER);
      }
    }
  }
  private void SetRaikoFirePower() {
    fire_power_ = min(me_.energy_ / 4, min(energy_ / 4, distance_ < 140 ? 3 : 2));
    //ready_to_fire_ = me_.energy_ > 1 || distance_ < 140;
  }
  private void CreateSnapshot(long elapsed) {
    _2ago_ = _1ago_;
    _1ago_ = _now_;
    _now_ = new Snapshot();
    //log_.add(0, /*_now_ = new Snapshot()*/);

    _now_.me_ = Bot.CloneMe();
    _now_.me_.UpdateToEnemy(this);
    if ( _1ago_ != null ) {
      _now_.me_.UpdateInTime(_1ago_.me_, elapsed);
      UpdateInTime(_1ago_.enemy_, elapsed);
    }

    _now_.enemy_ = new Bot(this);
    _now_.distance_ = distance_;
    _now_.NormalizeSnapshot();
  }
  public void UpdateMeleeGunScore(int gun, double score) {
    Roll(melee_gun_scores_, gun, 40000 / max(400, score), 11);
    //System.out.printf("New score for %s with gun %d is %.4f\n", name_, gun, melee_gun_scores_[gun]);
  }
}
