package zyx.mega.movement.melee;

/*
import static zyx.mega.utils.RoboUtils.*;
import static zyx.mega.utils.Config.*;
import static zyx.mega.utils.TurnHandler.*;
import static zyx.mega.utils.Range.*;
import static zyx.mega.geometry.Geometry.*;
import static robocode.Rules.*;
import static java.lang.Math.*;
import static java.lang.Double.*;
import static robocode.util.Utils.*;
import static zyx.mega.bot.Enemy.*;
import static zyx.mega.bot.Bot.*;
*/

import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Math.PI;
import static java.lang.Math.abs;
import static java.lang.Math.ceil;
import static java.lang.Math.cos;
import static java.lang.Math.exp;
import static java.lang.Math.max;
import static java.lang.Math.min;
import static java.lang.Math.random;
import static java.util.Arrays.fill;
import static zyx.mega.bot.Bot.HEIGHT;
import static zyx.mega.bot.Bot.WIDTH;
import static zyx.mega.bot.Bot.field_;
import static zyx.mega.bot.Enemy.Phonebook;
import static zyx.mega.bot.Enemy.alive_enemies_;
import static zyx.mega.bot.Enemy.closest_;
import static zyx.mega.geometry.Geometry.HALF_PI;
import static zyx.mega.utils.Range.CapLowHigh;
import static zyx.mega.utils.Range.Normalize;
import static zyx.mega.utils.TurnHandler.Move;
import static zyx.mega.utils.TurnHandler.me_;
import static zyx.mega.utils.TurnHandler.others_;
import static zyx.mega.utils.TurnHandler.robot_;
import static zyx.mega.utils.TurnHandler.time_;

import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;

import robocode.Bullet;
import zyx.debug.painter.Painter;
import zyx.mega.bot.Enemy;
import zyx.mega.bot.MeleeEnemy;
import zyx.mega.geometry.Point;


public class MinimumRisk {
  
  private static final int POINTS_TO_TRY = 160;
  private static final double GROWTH_RATE = 1e-1;
  private static final double RADIUS = 360;
  private static final double MIN_RAIDUS = 120;
  private static final double REST_RAIDUS = RADIUS - MIN_RAIDUS;
  public static boolean _paint_;

  public Point target_;
  private double risk_multiplier_;

  private Point positions_[] = new Point[7];
  private double positions_weight_[] = new double[positions_.length];
  private int position_index_;
  private LinkedList<DangerSpot> danger_spots_;

  public MinimumRisk() {
    for ( int i = 0; i < positions_.length; ++i ) positions_[i] = new Point();
    danger_spots_ = new LinkedList<DangerSpot>();
  }
  public void Init() {
    target_ = null;
    fill(positions_weight_, 0);
    danger_spots_.clear();
  }
  
  public void run() {
    if ( target_ != null && me_.distance(target_) < 20 ) target_ = null;
    if ( target_ != null && closest_ != null && me_.distance(target_) > closest_.distance_ * 1.2 ) target_ = null;
    if ( time_ % 7 == 0 ) {
      positions_[position_index_ = (position_index_ + 1) % positions_.length].setLocation(robot_.getX(), robot_.getY());
      positions_weight_[position_index_] = random() * 1.3 - 0.2;
      positions_[position_index_].x_ += random() * 16 - 8;
      positions_[position_index_].y_ += random() * 16 - 8;
    }
    if ( time_ > 31 && time_ < 37 ) {
      robot_.setAhead(0);
      return;
    }
    Point base = me_;
    if ( 3 < others_ && others_ < 6 ) {
      double X[] = new double[]{ 30, 970 };
      double Y[] = new double[]{ 30, 970 };
      double best_risk = POSITIVE_INFINITY;
      for ( double x : X ) for ( double y : Y ) {
        Point corner = new Point(x, y);
        if ( corner.distanceSq(me_) < 62500 ) {
          if ( _paint_ ) Painter.Add(corner, 20, Color.YELLOW);
          base = me_;
          break;
        }
        if ( _paint_ ) Painter.Add(corner, 80, Color.BLACK);
        double risk = RiskFactor(corner) * (0.2 + Normalize(me_.distanceSq(corner), 40000, 1000000, false) * 0.8);
        if ( risk < best_risk ) {
          best_risk = risk;
          base = corner;
        }
      }
    }
    double best_risk = target_ == null ? POSITIVE_INFINITY : (RiskFactor(target_) * risk_multiplier_);
    risk_multiplier_ += GROWTH_RATE;
    if ( base == me_ ) {
      Point point = new Point(base, me_.heading_ + (me_.velocity_ == 0 ? HALF_PI :(me_.velocity_ > 0 ? PI : 0)), 1);
      double risk = RiskFactor(point);
      if ( risk < best_risk ) {
        best_risk = risk;
        target_ = point;
        risk_multiplier_ = 0.3;
      }
    }
    for ( int i = 0; i < POINTS_TO_TRY || target_ == null; ++i ) {
      double r = min(closest_ == null ? POSITIVE_INFINITY : closest_.distance_, random() * REST_RAIDUS + MIN_RAIDUS);
      double x = random() * 2 - 1;
      double y = random() * 2 - 1;
      Point point = new Point(base.x_ + x * r, base.y_ + y * r);
      if ( _paint_ ) Painter.Add(point, 2, Color.BLACK);
      double risk = RiskFactor(point);
      if ( risk < best_risk ) {
        best_risk = risk;
        target_ = point;
        risk_multiplier_ = 0.7;
      }
      if ( i > POINTS_TO_TRY * 2 ) {
        target_ = new Point(WIDTH / 2, HEIGHT / 2);
        risk_multiplier_ = 10;
      }
    }
    if ( _paint_ ) {
      for ( int i = 0; i < positions_.length; ++i ) Painter.Add(positions_[i], 5, Color.MAGENTA);
      Painter.Add(base, 20, Color.RED);
      Painter.Add(target_, 10, Color.WHITE);
    }
    Move(me_.distance(target_), me_.Angle(target_));
  }
  private double RiskFactor(Point point) {
    if ( !field_.Inside(point, false) ) return POSITIVE_INFINITY;
    double angle = me_.Angle(point);
    double risk = 0;
    int limit = min(others_, Phonebook().size());
    for ( int e = 0; e < limit; ++e ) risk += BotRisk(alive_enemies_[e], point, angle);
    /**/
    for ( int i = 0; i < positions_.length; ++i ) {
      int j = (i + position_index_) % positions_.length;
      double anti_gravity = positions_weight_[j] / max(1e-5, point.distance(positions_[j]));
      risk += anti_gravity;
    }
    /**/
    String RR = danger_spots_.size() + " " + risk + " ";
    for ( Iterator<DangerSpot> it = danger_spots_.iterator(); it.hasNext(); ) {
      DangerSpot spot = it.next();
      //if ( _paint_ ) Painter.Add(spot.spot_, 5, Color.BLACK);
      if ( time_> spot.expiration_ ) {
        it.remove();
        //if ( _paint_ ) Painter.Add(spot.spot_, 5, Color.PINK);
      } else {
        double cosine = cos(angle - spot.heading_);
        double w = 0.35 + abs(cosine) * 0.65;
        cosine = cos(angle - spot.enemy_.bearing_);
        w += CapLowHigh(spot.enemy_.energy_ratio_, 0.5, 2)  * (0.5 + abs(cosine) * 1.5);
        //) / max(1e-5, point.distance(spot.spot_))
        //if ( cosine < 0 ) w *= 0.9;
        //risk += w;
        //max(1e-5, spot.enemy_.distance_)
        //w += spot.enemy_.energy_ratio_ * spot.danger_ * (0.1 + abs(cosine) * 0.9) / max(1e-5, spot.enemy_.distance_);
        //if ( cosine < 0 ) w *= 0.9;
        risk += w * spot.danger_  / max(1e-5, spot.enemy_.distance_ * point.distance(spot.spot_));
      }
    }
    RR += risk;
    //if ( danger_spots_.size() > 0 ) System.out.println("Risk: " + RR);
    /**/
    if ( point.x_ < 38 || point.x_ >= field_.width_ - 2 ) risk *= 1.5;
    if ( point.y_ < 38 || point.y_ >= field_.height_ - 2 ) risk *= 1.5;
    /**/
    return risk;
  }
  private double BotRisk(MeleeEnemy menemy, Point point, double angle){
    Enemy enemy = menemy.bot_;
    double cosine = cos(angle - enemy.bearing_);
    double w =
      (enemy.energy_ratio_ - (enemy.distance_ < 110 ? 1e-7 : 0)) *
      (0.2 + abs(cosine) * 0.8) *
      (exp(-enemy.last_hit_power_ * menemy.shots_sice_hit_ / 7) * 0.5 + 1.5) *
      //((1 - Normalize(time_ - enemy.scan_time_, -1, time_ - last_seen_.scan_time_, false)) * 0.3 + 0.7) *
    1;
    //if ( cosine < 0 ) w *= 0.9;
    double dsq = max(1e-9, point.distanceSq(enemy));
    return max(1, 2 * menemy.min_distance_ / dsq) * w / Math.sqrt(dsq);
  }
  public void onHitByBullet(Enemy enemy, Bullet bullet) {
    danger_spots_.add(new DangerSpot(
        enemy,
        new zyx.mega.geometry.Bullet(bullet),
        bullet.getHeadingRadians(),
        (int)(time_ + 3 * ceil(10 + 2 * bullet.getPower())),
        bullet.getPower() * ((1 + Normalize(enemy.energy_ratio_, 0.3, 2, true)) / (1 + Normalize(enemy.distance_, 200, 800, true)) )));
    //System.out.println("Have spots: " + danger_spots_.size());
  }
  public void onBulletHitBullet(Enemy enemy, Bullet bullet) {
    //danger_spots_.add(new DangerSpot(new zyx.mega.geometry.Bullet(bullet),
        //(int)(time_ + 3 * ceil(10 + 2 * bullet.getPower())),
        //bullet.getPower() / 3));
  }
  public void onHitWall() {
    target_ = null;
  }
  public void onHitRobot(Enemy enemy) {
    target_ = null;
  }
}
