package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class CrossL extends AdvancedRobot {
    private int dir = 1;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    ahead(100);
	    back(100);
	    turnRight(dir * 90);
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing, power;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	power = 600.0 / e.getDistance();
	setTurnGunRightRadians(Utils.normalRelativeAngle((bearing + Math.asin(e.getVelocity() * Math.sin(e.getHeadingRadians() - bearing) / Rules.getBulletSpeed(power))) - getGunHeadingRadians()));
	setFire(power);
    }
    
    @Override
    public void onHitByBullet(HitByBulletEvent e) {
	dir = -dir;
    }
}
