package hirataatsushi;

import robocode.*;
import java.awt.Color;


/**
 * TheRationality - a class by A.Hirata.
 * ^[ƁACxgƂɌĂ΂A
 * 󋵂ɉăXgeW[ύXt@Ng[\bhB
 * TargetManagerRadarSystemւFacadełB
 */
public class TheRationality implements RobocodeEvents
{
	//=============================================================
	//@tB[h̐錾
	//=============================================================
	//VOgCX^X
	private static TheRationality singleton = new TheRationality();
	//@ւ̎Q
	private AdvancedRobot myBot;
	//͂ɑ݂GɊւێ	
	private TargetManager targetManager = TargetManager.getInstance();
	//[_[VXeB[_[͂Ȃ󋵂ɂĂē삳B
	//[_[VXe̓̕ὠ[_[XEB[vIƂɔ
	//Cxg
	//			//ł̂悢[_
	//			//radar.sweep( targetManager.getIterator() );
	//Ƃ`ŋNB	
	private RadarSystem radar = RadarSystem.getInstance();
	
	//============================================================
	//@\bh̐錾
	//============================================================
	//--------------------------------------------
	//RXgN^
	private TheRationality(){
		System.out.println("TheTationality : Singleton instance created...");
	}
	//--------------------------------------------
	//^[Qbg}l[W[̃CX^XԂB
	public static TheRationality getInstance(){
		return singleton;
	}
	//--------------------------------------------
	//@ւ̎QƂZbg	
	public void setMyBot(AdvancedRobot bot){
		myBot = bot;
		initMyBot();
	}
	//󂯂Ď@
	private void initMyBot(){
		radar.setMyBot(myBot);
		targetManager.setMyBot(myBot);
		//FZbg
		myBot.setColors(Color.black,Color.black,Color.white);
		//[_[ACAꂼ̉]Ɨ
		myBot.setAdjustGunForRobotTurn(true);
		myBot.setAdjustRadarForGunTurn(true);
		myBot.setTurnRadarRight(360);
		//[_]IƂɔCxg`
		myBot.addCustomEvent(new RadarTurnCompleteCondition(myBot) );
	}
	
	//------------------------------------------------------------	
	//ǂȃXgeW[t^邩ft@Ng[\bh
	public TheSoul makeJudgement(){
		//݂͊e̕@̂̂iK̂߁A
		//̃\bhmakeJudgement{̋@\ł󋵂X
		//geW[I鏈͈؏ȂĂB
		
		
		// myBot : @ւ̎Q
		AimingStrategy new_as = new SimpleAimingStrategy(myBot);
		//MovingStrategy new_ms = new SimpleMovingStrategy(myBot);
		MovingStrategy new_ms = new CircularMovingStrategy(myBot);
		// myBotɐV𐁂ށI
		TheSoul soul = new TheSoul( myBot, new_as, new_ms );
		return soul;
	}
	
	
	
	//------------------------------------------------------------
	// ̐RobocodeEvents̃C^[tFCX
	//------------------------------------------------------------
	//-------------------------------
	//RobotNX甭Cxg
	public void onBulletHit(BulletHitEvent event){}
	public void onBulletHitBullet(BulletHitBulletEvent event){}
	public void onBulletMissed(BulletMissedEvent event){}
	//public void onDeath(DeathEvent event);
	public void onHitByBullet(HitByBulletEvent event){}
	public void onHitRobot(HitRobotEvent event){}
	public void onHitWall(HitWallEvent event){ 
		//myBot.back(100); 
	}
	public void onRobotDeath(RobotDeathEvent event){}
	public void onScannedRobot(ScannedRobotEvent event){ 
		targetManager.setTarget(event); 
	}
	public void onWin(WinEvent event){}
	//---------------------------------
	//AdvancedRobot甭Cxg
	public void onCustomEvent(CustomEvent event){
		if (event.getCondition() instanceof
			//Oĩ[_[XLÎŁA
			//̃[_[XL̎w[_[VXeɔsB
			RadarTurnCompleteCondition) 
				//ł̂悢[_
				radar.sweep( targetManager.getIterator() );	
	}
	public void onDeath(DeathEvent event){}
	public void onSkippedTurn(SkippedTurnEvent event){}
	
}
