package cjm.chalk;

import robocode.*;
import robocode.util.Utils;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.*;

public class Persuader {
	
	static TreeGun _mainGun;
	static FlatLogGun _adaptiveGun;
	static BaseGun _currentGun;
	static BaseGun _backupGun;
   
    //gun stats
	static double _shotsFired;
	static double _shotsHit;
	
	AdvancedRobot _robot;
	Rectangle2D.Double _field;
	Rectangle2D.Double _enemyBox;
	ArrayList<Scan> _nodeQueue = new ArrayList<Scan>(100);
	ScannedRobotEvent _lastScan;
	boolean _aiming = false;
	
	double _lastHeading = Double.MAX_VALUE;
	double _lastVelocity = Double.MAX_VALUE;
	double _lastVelocityChange;
	Point2D.Double _enemyPoint = new Point2D.Double();
	
	double _coolingRate;	
	
	public Persuader(AdvancedRobot robot){
		_robot = robot;
		_coolingRate = _robot.getGunCoolingRate();
		_field = new Rectangle2D.Double(18d, 18d, _robot.getBattleFieldWidth() - 36d, _robot.getBattleFieldHeight() - 36d);
		_enemyBox = new Rectangle2D.Double();		
		if(_mainGun == null){
			_mainGun = new TreeGun(robot);
		}
		if(_adaptiveGun == null){
			_adaptiveGun = new FlatLogGun(2500, 25, 0.5d, robot);
		}
		_mainGun.clear();
		_adaptiveGun.clear();
	}
	
	public void process(){		
		
		if(_lastScan == null){
			return;
		}
		
		if(_robot.getEnergy() == 0){
	        boolean hasReal = false;
	        for(int i = _nodeQueue.size(); --i >= 0;){
			    Scan s = _nodeQueue.get(i);
			    if(s.IsRealBullet){
			        hasReal = true;
			    }
	        }
	        if(!hasReal){
	            return;
	        }
	    }
		
		double enemyHeading = _robot.getHeadingRadians() + _lastScan.getBearingRadians();
		double relativeHeading = _lastScan.getHeadingRadians() - enemyHeading;
		double heading = _lastScan.getHeadingRadians();
		double x = _robot.getX();
		double y = _robot.getY();
		double distance = _lastScan.getDistance();
		_enemyPoint.setLocation(Math.sin(enemyHeading) * distance + x, Math.cos(enemyHeading) * distance + y);
		_enemyBox.setFrame(_enemyPoint.x - 18, _enemyPoint.y - 18, 36, 36);
		long time = _robot.getTime();
		double gunHeading = _robot.getGunHeadingRadians();		
			    
			//calculate indexes=====================		
		double velocity = _lastScan.getVelocity();
		double absVelocity = Math.abs(velocity);
		double lateralVelocity = velocity * Math.sin(relativeHeading);
		double advancingVelocity = -Math.cos(relativeHeading) * velocity;
		double direction = lateralVelocity < 0 ? -1 : 1;		
		
		double energy = _robot.getEnergy();
		double hitPercent = _shotsHit / Math.max(_shotsFired, 1d);
		double shotPower = 1.90d;
		if(distance < 125d){
			shotPower = 3.0d;
		}
		else if(energy < 10d && _lastScan.getEnergy() > energy){
			shotPower = 1d;
		}		
		else if(_robot.getRoundNum() > 5 && hitPercent > 0.16d){
			shotPower = 2.5d;
		}
		
		shotPower = Math.min(Math.min(Math.max(_lastScan.getEnergy() / 4d, 0.1d), shotPower), _robot.getEnergy() - 0.100001d);
		
		if(cjm.Debug.IS_TC){
		    shotPower = 3d;
		}
		double acceleration = 0;
		if(_lastVelocity != Double.MAX_VALUE){
		    
			if(ChalkUtils.sign(_lastVelocity) == ChalkUtils.sign(velocity)){
				acceleration = Math.abs(velocity) - Math.abs(_lastVelocity);
			}
			else{
				acceleration = Math.abs(velocity - _lastVelocity);
			}
		}
		else{
			acceleration = velocity;
		}
		acceleration = Math.abs(Math.max(Math.min(acceleration, 2d), -2d));
		
		_lastVelocityChange++;
		if(Math.abs(_lastVelocity - velocity) > 0.1){
		    _lastVelocityChange = 0;
		}
		double velocityChangeValue = Math.min(_lastVelocityChange , 35d);	
		
		//wall distance forward
		double wallTries = getWallTries(enemyHeading, direction, x, y, distance);
		double wallTriesBack = getWallTries(enemyHeading, -direction, x, y, distance);
		
		lateralVelocity = Math.abs(lateralVelocity);
		   
		Scan scan = new Scan();
		scan.Time = time - 1;
		scan.LateralVelocity = lateralVelocity / 8d;
		scan.AdvancingVelocity = advancingVelocity / 32d;
		scan.WallTriesForward = wallTries / 20d;
		scan.WallTriesBack = wallTriesBack / 20d;
		scan.NormalizedDistance = distance / 800d;
		scan.Distance = distance;
		scan.Velocity = absVelocity / 8d;
		scan.Acceleration = acceleration / 2d;
		scan.SinceVelocityChange = velocityChangeValue / 35d;
		scan.GunHeat = _robot.getGunHeat() / 1.6d;
		scan.Direction = direction;
		scan.EnemyHeading = enemyHeading;
		scan.RX = x;
		scan.RY = y;
		if(shotPower > 0){
		    scan.setBulletVelocity(shotPower);
		}
		else{
		    scan.setBulletVelocity(1.90d);
		}	
		
		_nodeQueue.add(scan);
		
		//check for virtual hits
		_mainGun.checkVirtualBullets(time, _enemyBox);
		_adaptiveGun.checkVirtualBullets(time, _enemyBox);
		
		for(int i = _nodeQueue.size(); --i >= 0;){
		    Scan s = _nodeQueue.get(i);
		    if(s.getDistance(time) > distance - s.BulletVelocity * 0.5d){
		       if(!s.setBearing(_enemyPoint.x, _enemyPoint.y)){
		    	   _mainGun.addScan(s);		    	 
		    	   _adaptiveGun.addScan(s);		    	  
		       }
		    }
		  
		    if(s.getDistance(time) > (distance + 30d)){
		        _nodeQueue.remove(i);
		        _mainGun.removePassed(s);
		    	_adaptiveGun.removePassed(s);
		    }
		}
		
		if(shotPower > 0 && _robot.getOthers() > 0 && _robot.getGunHeat() / _coolingRate < 2d){			
			
			double mainRating = _mainGun.getRatingPercent();
			if(_robot.getRoundNum() > 2 
					&& (
							(_adaptiveGun.getRatingPercent() > mainRating + 0.005d && hitPercent < 0.12d)
							|| (_adaptiveGun.getRatingPercent() > mainRating && hitPercent < 0.10d)
					)){
				_currentGun = _adaptiveGun;
				_backupGun = _mainGun;
			}
			else{
				_currentGun = _mainGun;
				_backupGun = _adaptiveGun;
			}			
			
			double bearing = _currentGun.projectBearing(scan, x, y, enemyHeading);			
			
			_aiming = true;
		    if(bearing < Double.MAX_VALUE && distance > 70d){
		    	_robot.setTurnGunRightRadians(Utils.normalRelativeAngle(enemyHeading + bearing - gunHeading));
		    }
		    else{
		    	 //http://www.robowiki.net/cgi-bin/robowiki?CircularTargeting
				//Derived from robowiki.net & GrubbmGrb
			    //this should only be used in ultra-close-range
			    //or once for an early anti-Musashi Trick shot
				double projectedTime = 0;
				double dX = _enemyPoint.x;
				double dY = _enemyPoint.y;
				double currentHeading = heading;
				double deltaHeading = heading - _lastHeading;
				do{
					projectedTime++;
					dX += Math.sin(currentHeading) * velocity;
					dY += Math.cos(currentHeading) * velocity;
					currentHeading += deltaHeading;
	
				}while(Point2D.distance(x, y, dX, dY) > projectedTime * scan.BulletVelocity && _field.contains(dX, dY));
				
				_robot.setTurnGunRightRadians(Utils.normalRelativeAngle(Math.atan2(dX - x, dY - y) - gunHeading));
		    }
		    
		    if(bearing < Double.MAX_VALUE
		    		&& (Math.abs(_robot.getGunTurnRemainingRadians()) < Math.atan(15d / distance) || distance < 125d) 
		    		&& _robot.setFireBullet(shotPower) != null){
			    
				scan.IsRealBullet = true;
				_aiming = false;
				_shotsFired++;	
				
				_currentGun.takeVirtualShot(scan, bearing);
			
				double br = _backupGun.projectBearing(scan, x, y, enemyHeading);
				if(br != Double.MAX_VALUE){					
					_backupGun.takeVirtualShot(scan, br);
				}
							
			}
		}

		if(!_aiming){
		    _robot.setTurnGunRightRadians(Utils.normalRelativeAngle(enemyHeading - gunHeading));
		}
		
		_lastVelocity = velocity;
		_lastScan = null;
		_lastHeading = heading;
	}	
	
	public double getWallTries(double heading, double dir, double x, double y, double distance){		

		double wallIncrement = 0.0407d * dir;
		double eHeading = heading;
		double nextX = 0;
		double nextY = 0;
		double wallTries = -1;
		do{
		    eHeading += wallIncrement;
		    nextX = x + Math.sin(eHeading) * distance;
		    nextY = y + Math.cos(eHeading) * distance;
		    wallTries++;
		}while(_field.contains(nextX, nextY) && wallTries < 20);
		
		return wallTries;
	}
	
	public void onScannedRobot(ScannedRobotEvent sre){
		_lastScan = sre;
	}
	
	public String getStats(){
	    return "Total Chalker Hit %: " + ((_shotsHit / _shotsFired) * 100) + "\n" +
	    	"Total Shots: " + _shotsFired + "\n" +
		    "Main Gun %: " + _mainGun.getRatingPercent() + "\n" +
		    "Main Gun Scan Count: " + _mainGun.Count + "\n" +
	    	"Adaptive Gun% Rating: " + _adaptiveGun.getRatingPercent() + "\n";
	}
	
	public void onBulletHit(BulletHitEvent e){
		
		double bulletX = e.getBullet().getX();
		double bulletY = e.getBullet().getY();
		long time = _robot.getTime();
		double greatestDistance = Double.MAX_VALUE;
		Scan best = null;
		for(int i = _nodeQueue.size(); --i >= 0;){
			Scan s = _nodeQueue.get(i);
			double d = Math.abs(s.getDistance(time) - Point2D.distance(s.RX, s.RY, bulletX, bulletY));
			if(d < greatestDistance && d < 20d){
				greatestDistance = d;
				best = s;
			}
		}		
		
		if(best != null){
			best.registerHit(bulletX, bulletY);
		}
		
		_shotsHit++;
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e){

		double bulletX = e.getBullet().getX();
		double bulletY = e.getBullet().getY();
		long time = _robot.getTime();
		double greatestDistance = Double.MAX_VALUE;
		Scan best = null;
		for(int i = _nodeQueue.size(); --i >= 0;){
			Scan s = _nodeQueue.get(i);
			double d = Math.abs(s.getDistance(time) - Point2D.distance(s.RX, s.RY, bulletX, bulletY));
			if(d < greatestDistance && d < 20d){
				greatestDistance = d;
				best = s;
			}
		}
		
		if(best != null){
			best.registerHit(bulletX, bulletY);
		}
	}
}
