package rcp;

import robocode.*;
import java.awt.geom.*;
import robocode.util.*;

/**
 * Kuramatron - a robot by Rafael C.P. (Kurama_Youko)
 * 
 * A rambot with linear targeting, radar locking and energy management
 */
public class Kuramatron extends AdvancedRobot {

    double battleFieldHeight, battleFieldWidth;

	public void run() {
		setAdjustGunForRobotTurn(true);
        battleFieldHeight = getBattleFieldHeight();
		battleFieldWidth = getBattleFieldWidth();
		while (true) {
			System.out.println("teste");
			turnRadarRight(Double.POSITIVE_INFINITY); //Radar search
		}
	}
	
	/**
	 * Fire when we see a robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		setTurnRight(e.getBearing());
		setAhead(e.getDistance() + 5);	//Ram
		linearTargeting(e);
		setTurnRadarLeft(getRadarTurnRemaining());  //Radar lock
		execute();
	}

	public double maxBulletPower(ScannedRobotEvent e) {
		//Don't shoot with power equal or greater than own energy
		//Don't shoot with power greater than target energy
		//Try to use maximum power
		return Math.min(Math.min(3,getEnergy()-0.1),e.getEnergy());
	}
	
	public void linearTargeting(ScannedRobotEvent e) {
		double bulletPower = maxBulletPower(e), myX = getX(), myY = getY(), deltaTime = 0;
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double predictedX = myX + e.getDistance() * Math.sin(absoluteBearing);
		double predictedY = myY + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians(), enemyVelocity = e.getVelocity();
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 17
				|| predictedY < 17
				|| predictedX > battleFieldWidth - 17
				|| predictedY > battleFieldHeight - 17){
				predictedX = Math.min(Math.max(17, predictedX), battleFieldWidth - 17);	
				predictedY = Math.min(Math.max(17, predictedY), battleFieldHeight - 17);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - myX, predictedY - myY));
		setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
		setFire(bulletPower);
	}
}												