package ag.team;

/**
 * Stores information about a bullet
 * @author Andree Grosse
 */
public class Team_BulletData implements java.io.Serializable {

	static final long serialVersionUID = 1002;
	
	String mOwner;
	long mTick;
	double mX, mY, mHeading, mPower;
	
	/**
	 * Constructor.
	 */
	public Team_BulletData(String owner, long tick, double x, double y, 
			double heading, double power) {
		super();
		mOwner = owner;
		mTick = tick;
		mX = x;
		mY = y;
		mHeading = heading;
		mPower = power;
	}
	
	/**
	 * Returns the heading of the bullet.
	 * @return the heading of the bullet.
	 */
	public double getHeading() {
		return mHeading;
	}

	/**
	 * Returns the name of the bullet.
	 * @return the name of the bullet.
	 */
	public String getOwner() {
		return mOwner;
	}

	/**
	 * Returns the tick for this dataset.
	 * @return the tick for this dataset.
	 */
	public long getTick() {
		return mTick;
	}

	/**
	 * Returns the velocity of the bullet.
	 * @return the velocity of the bullet.
	 */
	public double getPower() {
		return mPower;
	}

	/**
	 * Returns the x-position of the bullet.
	 * @return the x-position of the bullet.
	 */
	public double getX() {
		return mX;
	}

	/**
	 * Returns the y-position of the bullet.
	 * @return the y-position of the bullet.
	 */
	public double getY() {
		return mY;
	}

}
