/*
 * Created on 2004-10-9
 */
package tide;

import tide.util.Utils;


/**
 * this event occurred when one of your bullets hits another bullet
 *
 *  @author xiemin
 */
public class BulletHitBulletEvent extends Event
{
	//the position the two bullets hited
	private double x, y;
	//the name of the another bullet's owner
	private String name;
	//the heading of the another bullet
	private double heading;
	//the heading of the another bullet
	private double power;
	
	/**
	 * create a new BulletHitBulletEvent. 
	 * @param event the robocode BulletHitBulletEvent
	 */
	public BulletHitBulletEvent(robocode.BulletHitBulletEvent event)
	{
		super(event);
		x = event.getHitBullet().getX();
		y = event.getHitBullet().getY();
		name = event.getHitBullet().getName();
		power = event.getHitBullet().getPower();
		heading = Utils.transform(event.getHitBullet().getHeadingRadians());
	}
	
	/**
	 * @return Returns the heading.
	 */
	public double getHeading()
	{
		return heading;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName()
	{
		return name;
	}
	/**
	 * @return Returns the power.
	 */
	public double getPower()
	{
		return power;
	}
	/**
	 * @return Returns the x.
	 */
	public double getX()
	{
		return x;
	}
	/**
	 * @return Returns the y.
	 */
	public double getY()
	{
		return y;
	}
}
