/*
 * Created on 2004-10-9
 */
package tide;

/**
 * this event occurred when you are hit by a bullet
 * 
 * @author xiemin
 */
public class HitByBulletEvent extends Event
{
	//the power of the bullt
	private double power;
	//the name of the bullet's owner
	private String name;
	
	//the position the bullet hited
	private double x, y;
	

	/**
	 * create a new HitByBulletEvent.
	 * @param event the robocode HitByBulletEvent
	 */
	public HitByBulletEvent(robocode.HitByBulletEvent event)
	{
		super(event);
		this.power = event.getPower();
		this.name = event.getName();
		this.x = event.getBullet().getX();
		this.y = event.getBullet().getY();
	}
	
	/**
	 * Return the power of the bullet
	 * @return the power of the bullet
	 */
	public double getPower()
	{
		 return power;
	}

	/**
	 * Return the name of the bullet's owner
	 * @return the name of the bullet's owner
	 */
	public String getName()
	{
		 return name;
	}
	
	/**
	 * @return the bullet's x
	 */
	public double getX(){
		return x;
	}
	
	/**
	 * @return the bullet's y
	 */
	public double getY(){
		return y;
	}
}


