package wiki.rmove;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.*;
/*
   Raiko Movement without the MusashiTrick
   For use in the RoboRumble Gun Challenge - http://robowiki.net/?RRGunChallange

   Raiko 0.41 by Jamougha.  

   Credit for ideas or parts of this code go to PEZ, Kawigi and probably others who I've forgotten to mention.

   Released under the RWPCL - RoboWiki Public Code Licence - http://robowiki.net/?RWPCL
 */

public class RaikoNMT {
    static final double BEST_DISTANCE = 525;
    static double circleDir = 1, enemyFirePower, enemyEnergy;

    AdvancedRobot robot;

    public RaikoNMT(AdvancedRobot robot) {
	this.robot = robot;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
	Point2D.Double robotLocation = new Point2D.Double(robot.getX(), robot.getY());
	double theta;
	double enemyAbsoluteBearing = robot.getHeadingRadians() + e.getBearingRadians();
	double enemyDistance = e.getDistance();
	Point2D.Double enemyLocation = projectMotion(robotLocation, enemyAbsoluteBearing, enemyDistance);

	if ((enemyEnergy -= e.getEnergy()) >= 0.1 && enemyEnergy <= 3.0) {
	    enemyFirePower = enemyEnergy;
	}

	enemyEnergy = e.getEnergy();

	Rectangle2D.Double BF = new Rectangle2D.Double(18, 18, 764, 564);

	Point2D.Double newDestination;

	double distDelta = 0.02 + Math.PI/2 + (enemyDistance > BEST_DISTANCE  ? -.1 : .5);

	while (!BF.contains(newDestination = projectMotion(robotLocation, enemyAbsoluteBearing + circleDir*(distDelta-=0.02), 170)));

	theta = 0.5952*(20D - 3D*enemyFirePower)/enemyDistance;
	if ((Math.random() > Math.pow(theta, theta)) || distDelta < Math.PI/5 || (distDelta < Math.PI/3.5 && enemyDistance < 400)) {
	    circleDir = -circleDir;
	}

	theta = absoluteBearing(robotLocation, newDestination) - robot.getHeadingRadians();
	robot.setAhead(Math.cos(theta)*100);
	robot.setTurnRightRadians(Math.tan(theta));
    }

    private static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance){
	return new Point2D.Double(loc.x + distance*Math.sin(heading), loc.y + distance*Math.cos(heading));			
    }

    private static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
	return Math.atan2(target.x - source.x, target.y - source.y);
    }
}
