/***************************************************************************************
*  Robot:  micro.TimXJ
*  Author: Liuyang
*  Create: 2003.04.25
*  Tips:   Limit Sharpshooter.
*......................................................................................
*  v0.11 - 2003.04.25 - 566 - Create shoot beginer bot this.
*  v0.12 - 2003.04.29 - 561 - Test new shoot method.
*  v0.20 - 2003.08.12 - 715+26 - Usage Virtual Bullet Attack.
*  v0.21 - 2003.08.15 - 709+26 - Modify movement method.
*  v0.22 - 2003.09.02 - 719+26 - Fix vData to store VirtualBullet info.
****************************************************************************************/
package timmit.micro;

import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;

public class TimXJ extends AdvancedRobot{
	
	static long moveTime;
	//static double epEnergy;
	static ArrayList v = new ArrayList();
	static double[][] vData = new double[8][129];	//[distance][vIndex]
	
	public void run(){
		setColors(Color.green,Color.green,Color.white);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		do{
			turnRadarRightRadians(1);
		}while(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e){
		//INITIALIZE//
		double cx = getX(),cy = getY(),distance = e.getDistance(),velocity = e.getVelocity();
		double absBearing = getHeadingRadians() + e.getBearingRadians(),eHead = e.getHeadingRadians() - absBearing;
		double power = Math.min(Math.min(getEnergy()/3,e.getEnergy()/2),3);
		//double power = 260/Math.max(e.getDistance(),120) + 0.9,speed = 20 - 3 * power;
		int dIndex = Math.min((int)(distance/100),7),vIndex = 64;
		Point2D.Double ePoint = this.getPoint(cx,cy,absBearing,distance);
		
		//ROBOT MOVEMENT METHOD//
		//if(epEnergy!=(epEnergy = e.getEnergy())){
		if(--moveTime <= 0){
			moveTime = (long)(Math.random() * distance / 13);
			double nextX,nextY,bestAngle = 0,turn = 0,dist = 0;
			for(int vi=0;vi<129;vi++){
				//CALCULATE NEXT POINT//
				nextX = Math.random() * (this.getBattleFieldWidth() - 36) + 18;
				nextY = Math.random() * (this.getBattleFieldHeight() - 36) + 18;
				/**
				 *  bestAngle must more than PI/3.
				 */
				if(bestAngle < (bestAngle = Math.max(Math.abs(Math.tan(angleOf(cx,cy,nextX,nextY) - absBearing)),Math.PI/3))){
					turn = relativeOf(angleOf(cx,cy,nextX,nextY) - getHeadingRadians());
					dist = Point2D.Double.distance(cx,cy,nextX,nextY);
				}
				
				//FIRE VIRTUAL BULLET//
				/**
				 *  Calculate linear angle offset to set the gun turn.
				 */
				v.add(new VirtualBullet(dIndex,vi,absBearing + linearOf(vi,eHead),new Point2D.Double(cx,cy)));
			}
			if(Math.abs(turn) > Math.PI/2){
				turn += Math.PI;
				dist = -dist;
			}
			setTurnRightRadians(relativeOf(turn));
			setAhead(dist);
		}
		
		//GUN TURN METHOD//
		for(Iterator iter = v.iterator();iter.hasNext();){
			VirtualBullet vb = (VirtualBullet)iter.next();
			/**
			 *   virtual bullet traveled distance more than origin prediction distance.
			 */
			double distanceTraveled;
			if((distanceTraveled = (vb.traveled += 11)) > ePoint.distance(vb.oPoint)){
				vData[vb.dIndex][vb.vIndex] *= 0.99;
				if(this.getPoint(vb.oPoint.x,vb.oPoint.y,vb.absBearing,distanceTraveled).distance(ePoint) < 30){
					vData[vb.dIndex][vb.vIndex] += 0.01;
				}
				iter.remove();
			}
			//SEARCH BEST VINDEX//
			if(vData[dIndex][vb.vIndex] > vData[dIndex][vIndex]){
				vIndex = vb.vIndex;
			}
		}
		setTurnGunRightRadians(relativeOf(absBearing - getGunHeadingRadians() + linearOf(vIndex,eHead)));
		
		//SHOOT ENEMY METHOD//
		if(getGunHeat()==0 && getEnergy() - power > 0.2){
			setFire(power);
		}
		
		//RADAR TURN METHOD//
		setTurnRadarRightRadians(relativeOf(absBearing - getRadarHeadingRadians()) * 1.5);
		scan();
	}
	
	//public void onHitWall(HitWallEvent e){
	//	out.println("HitWall Point x = "+(int)getX()+" y = "+(int)getY());
	//}
	
	//------------------- helper -----------------------//
	static double relativeOf(double r){return Math.atan2(Math.sin(r),Math.cos(r));}
	
	static double angleOf(double x1,double y1,double x2,double y2){return Math.atan2(x2-x1,y2-y1);}
	
	/**
	 *  param ehead  = e.getHeadingRadians() - absBearingRadians
	 */
	static double linearOf(int vi,double ehead){return Math.asin((vi-64)*0.125 * Math.sin(ehead)/11);}
	
	static Point2D.Double getPoint(double originX,double originY,double absBearing,double distance){
		return new Point2D.Double(originX + Math.sin(absBearing) * distance,originY + Math.cos(absBearing) * distance);
	}
}

/**
 *  Virtual Bullet class - codesize = 26
 */
class VirtualBullet{
	int dIndex,vIndex;
	double absBearing,traveled;
	Point2D.Double oPoint;
	
	VirtualBullet(int dIndex,int vIndex,double absBearing,Point2D.Double oPoint){
		this.dIndex = dIndex;
		this.vIndex = vIndex;
		this.absBearing = absBearing;
		this.oPoint = oPoint;
	}
}