package dsekercioglu.mega;

import dsekercioglu.mega.wfGun.Fangs;
import dsekercioglu.mega.wfMove.Lightning;
import dsekercioglu.mega.wfEyes.Lock;
import dsekercioglu.mega.wolfBreath.WolfBreath;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class WFDataSaver extends AdvancedRobot {

    public static Lock radar;
    public static Lightning move;
    public static Fangs gun;
    public static WolfBreath shield;

    public double damageTaken = 0;
    boolean killModeOn = false;
    static boolean shieldOff = true;
    
    public static String enemyName = "";

    public void run() {
        setBodyColor(new Color(192, 192, 192));
        setGunColor(new Color(76, 76, 76));
        setRadarColor(new Color(0, 0, 0));
        setScanColor(new Color(0, 0, 0));
        setBulletColor(new Color(255, 255, 255));

        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

        if (getRoundNum() == 0) {
            radar = new Lock(this);
            move = new Lightning(this);
            gun = new Fangs(this, false);
            shield = new WolfBreath(this);
        }

        move.run();
        gun.run();
        shield.run();
        radar.run();
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        enemyName = e.getName();
        radar.onScannedRobot(e);
        if (getEnergy() / e.getEnergy() > 7.5) {
            killModeOn = true;
        }
        if (damageTaken > 50) {
            shieldOff = true;
        }
        if (shieldOff || killModeOn) {
            move.onScannedRobot(e);
            gun.setNextPosition(move.getNextPosition());
            //gun.setNextPosition(new Point2D.Double(getX(), getY()));
            gun.onScannedRobot(e);
        } else {
            shield.onScannedRobot(e);
        }
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        if (shieldOff || killModeOn) {
            move.onHitByBullet(e);
        } else {
            shield.onHitByBullet(e);
        }
        damageTaken += Rules.getBulletDamage(e.getBullet().getPower());
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (shieldOff || killModeOn) {
            gun.onBulletHitBullet(e);
            move.onBulletHitBullet(e);
        }
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        if (!shieldOff && !killModeOn) {
            shield.onBulletHit(e);
        } else {
            gun.onBulletHit(e);
        }
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
        if (shieldOff || killModeOn) {
            gun.onRoundEnded(e);
            move.onRoundEnded(e);
        }
        if (getRoundNum() == 34) {
            gun.onBattleCompleted(null);
        }
    }

    @Override
    public void onDeath(DeathEvent e) {
        shieldOff = true;
        //gun.onBattleCompleted(null);
    }

    public void onPaint(Graphics2D g) {
        if (shieldOff || killModeOn) {
            gun.onPaint(g);
            move.onPaint(g);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        shieldOff = true;
    }

}
