package tobe.movement;
import robocode.*;
import tobe.util.*;
    /**
     *
     * Weaves its way toward its foe
     */
    public class NewWeave_1 extends AbstractStrategy {
        
        private double movement;
        private double turnDoneTime;
		private double dodgeDoneTime;
        
        private HitWallEvent hitWall;
        private HitRobotEvent hitRobot;
        
        private String trackedName;
        private double trackedTime;
		private double trackedLife = 0;
		private double lastTrackedLife = 0;
        private BearingVector trackedPosition = new BearingVector();
        private BearingVector trackedMovement = new BearingVector();
        private BearingVector v = new BearingVector();
        
        public boolean go(AdvancedRobot bot) {
            if(hitRobot != null) {
                goHitRobot(bot, hitRobot);
                hitRobot = null;
            } else if(hitWall != null) {
                goHitWall(bot, hitWall);
                hitWall = null;
			} else if(Math.random() > 0.5 && trackedLife + 0.3 < lastTrackedLife && trackedLife + 3 >= lastTrackedLife &&  bot.getTime() > dodgeDoneTime) {//maybe he fired more than 0.3
//			} else if(trackedLife + 0.3 < lastTrackedLife && bot.getTime() > dodgeDoneTime) {//maybe he fired more than 0.3
				goDodge(bot);
            } else if(bot.getTime() > turnDoneTime && bot.getTime() > dodgeDoneTime) {
                goTurnAndMove(bot);
            } else if(bot.getDistanceRemaining() < 15 && bot.getTurnRemaining() < 5) {
            	double myHeading = bot.getHeadingRadians();
            	if( movement < 0 ) myHeading -= Math.PI;
            	if(myHeading < 0) myHeading += Math.PI*2;

                v.setPoints(bot.getX(), bot.getY(), trackedPosition.getToX(), trackedPosition.getToY());

				double turn=normalizeAngle(v.getBearing() + Math.PI/2.0 - myHeading);
            	if( turn < -Math.PI/2.0 || turn > Math.PI/2.0 ) {
                	turn = normalizeAngle(turn + Math.PI);
                }
				bot.setTurnRightRadians(turn);
            }
            return false;
        }
        
		//thanks to graygoo and Grasshopper for this kind of idea
		private void goDodge(AdvancedRobot bot) {
            double myHeading = bot.getHeadingRadians();
            if( movement < 0 ) myHeading -= Math.PI;
            if(myHeading < 0) myHeading += Math.PI*2;

			if( trackedName == null )
				v.setPoints(bot.getX(), bot.getY(), bot.getBattleFieldWidth()/2, bot.getBattleFieldHeight()/2);
			else
                v.setPoints(bot.getX(), bot.getY(), trackedPosition.getToX(), trackedPosition.getToY());

			double sec1 = bot.getWidth()+5;
			double sec2 = 2.0*sec1;
			double sec3 = sec2 + sec1;
			double radius = v.getDistance();
			double a3 = Math.asin(sec3/2.0/radius)*2.0;
			double angle = 2.0*a3;
			double arc = angle * radius;
			double idealAngle = Math.PI/3;
			double idealRadius = sec3/2.0/Math.sin(idealAngle/4.0);
			if( angle > idealAngle) {
				radius += 20;
				a3 = Math.asin(sec3/2.0/radius)*2.0;
				/*angle = Math.PI;
				a3 = angle/2;
				radius = sec3/2/Math.sin(a3/2);*/
			}
			if( angle < idealAngle) {
				radius -= 20;
				a3 = Math.asin(sec3/2.0/radius)*2.0;
			}
			
			double a2 = Math.asin(sec2/2.0/radius)*2.0;
			double a1 = Math.asin(sec1/2.0/radius)*2.0;
			
			v.setDistance(radius);
			
			double time = 16;
			
            int choice = (int) Math.floor(Math.random()*7.0);
            switch(choice) {
                case 0: v.setBearing(v.getBearing() + a1); /*time = 8; /*time *= (0.25+0.5*Math.random());*/ break;
                case 1: v.setBearing(v.getBearing() + a2); /*time = 12; /*time *= (0.4+0.5*Math.random());*/ break;
                case 2: v.setBearing(v.getBearing() + a3); /*time *= (0.8+0.2*Math.random());*/ break;
                case 3: v.setBearing(v.getBearing() - a1); /*time = 8;/*time *= (0.25+0.5*Math.random());*/ break;
                case 4: v.setBearing(v.getBearing() - a2); /*time = 12;/*time *= (0.4+0.5*Math.random());*/ break;
                case 5: v.setBearing(v.getBearing() - a3); /*time *= (0.8+0.2*Math.random());*/ break;
                case 6: time = 8; /*time *= (0.1+0.4*Math.random());*/ break;
            }
			//if(dodging) time = 4;
            
			double x = v.getToX();
			if( x < bot.getWidth() ) x = bot.getBattleFieldWidth() - bot.getWidth();
			if( x > bot.getBattleFieldWidth() - bot.getWidth()) x = bot.getWidth();
			double y = v.getToY();
			if( y < bot.getWidth() ) y = bot.getBattleFieldHeight() - bot.getWidth();
			if( y > bot.getBattleFieldHeight() - bot.getWidth()) y = bot.getWidth();
            v.setPoints(x,y,bot.getX(), bot.getY());
            double turn = normalizeAngle(v.getBearing() - myHeading);
            double move = v.getDistance();
            
			if( turn < -Math.PI/2.0 || turn > Math.PI/2.0 ) {
                turn = normalizeAngle(turn + Math.PI);
                movement = -movement;
            }
            bot.setMaxVelocity(8);
            if( movement < 0) move=-move;
            bot.setTurnRightRadians(turn);
            bot.setAhead(move);
            dodgeDoneTime = bot.getTime() + time;//*(0.5 + 0.7*Math.random());
		}
        
        
        private void goTurnAndMove(AdvancedRobot bot) {
            double turn;
            double myHeading = bot.getHeadingRadians();
            if( movement < 0 ) myHeading -= Math.PI;
            if(myHeading < 0) myHeading += Math.PI*2;
            if(trackedName == null){
				//start for the centre
                v.setPoints(bot.getBattleFieldWidth()/2, bot.getBattleFieldHeight()/2, bot.getX(), bot.getY());
				//up, down or middle?
				double r = Math.random();
				if( r<0.4 ) v.add(0, bot.getBattleFieldHeight()/4);
				else if( r>0.6) v.add(Math.PI , bot.getBattleFieldHeight()/4);
				//left, right or middle?
				r = Math.random();
				if( r<0.4 ) v.add(-Math.PI/2, bot.getBattleFieldWidth()/4);
				else if( r>0.6) v.add(Math.PI/2 , bot.getBattleFieldWidth()/4);
            } else {
                //where is he going? head him off
                v.setSum(trackedPosition, trackedMovement, trackedPosition.getDistance()/6);
                //get behind him
                v.add(trackedMovement.getAbsoluteBearing(), -150);
                //do not go outside battlefield
                if(v.getToX() < 0) v.setDistanceToX(bot.getWidth());
                if(v.getToX() > bot.getBattleFieldWidth())
                    v.setDistanceToX(bot.getBattleFieldWidth() - bot.getWidth());
                if(v.getToY() < 0) v.setDistanceToY(bot.getWidth());
                if(v.getToY() > bot.getBattleFieldHeight())
                    v.setDistanceToY(bot.getBattleFieldHeight() - bot.getWidth());
                
                //get closer to the centre
                v.changeOrigin(bot.getBattleFieldWidth()/2, bot.getBattleFieldHeight()/2);
                v.setDistance(v.getDistance() - 100);
                //where is this from me?
                v.changeOrigin(bot.getX(), bot.getY());
                //if close, move away and around the spot
                if(Math.abs(trackedPosition.getDistance()) < 350) {
                    v.add(trackedPosition.getBearing(), -200);
                }
				//if outside bounds, try to go around
				if(v.getToX() < 0) {
					if(trackedPosition.getToY() < bot.getBattleFieldHeight()/2 - 100) {
						v.pointTo(100, v.getToY() + bot.getBattleFieldHeight()/4);
					} else if(trackedPosition.getToY() > bot.getBattleFieldHeight()/2 + 100) {
						v.pointTo(100, v.getToY() - bot.getBattleFieldHeight()/4);
					} else if(bot.getY() > bot.getBattleFieldHeight()/2) {
						v.pointTo(100, v.getToY() + bot.getBattleFieldHeight()/4);
					} else {
						v.pointTo(100, v.getToY() - bot.getBattleFieldHeight()/4);
					}
				}
				if(v.getToX() > bot.getBattleFieldWidth()) {
					if(trackedPosition.getToY() < bot.getBattleFieldHeight()/2) {
						v.pointTo(bot.getBattleFieldWidth()-100, v.getToY() + bot.getBattleFieldHeight()/4);
					} else if(trackedPosition.getToY() > bot.getBattleFieldHeight()/2 + 100) {
						v.pointTo(bot.getBattleFieldWidth()-100, v.getToY() - bot.getBattleFieldHeight()/4);
					} else if(bot.getY() > bot.getBattleFieldHeight()/2) {
						v.pointTo(bot.getBattleFieldWidth()-100, v.getToY() + bot.getBattleFieldHeight()/4);
					} else {
						v.pointTo(bot.getBattleFieldWidth()-100, v.getToY() - bot.getBattleFieldHeight()/4);
					}
				}
				if(v.getToY() < 0) {
					if(trackedPosition.getToX() < bot.getBattleFieldWidth()/2-100) {
						v.pointTo(v.getToX() + bot.getBattleFieldWidth()/4, 100);
					} else if(trackedPosition.getToX() > bot.getBattleFieldWidth()/2+100) {
						v.pointTo(v.getToX() - bot.getBattleFieldWidth()/4, 100);
					} else if(bot.getX() > bot.getBattleFieldWidth()/2) {
						v.pointTo(v.getToX() + bot.getBattleFieldWidth()/4, 100);
					} else {
						v.pointTo(v.getToX() - bot.getBattleFieldWidth()/4, 100);
					}
				}
				if(v.getToY() > bot.getBattleFieldHeight()) {
					if(trackedPosition.getToX() < bot.getBattleFieldWidth()/2) {
						v.pointTo(v.getToX() + bot.getBattleFieldWidth()/4, bot.getBattleFieldHeight()-100);
					} else if(trackedPosition.getToX() > bot.getBattleFieldWidth()/2+100) {
						v.pointTo(v.getToX() - bot.getBattleFieldWidth()/4, bot.getBattleFieldHeight()-100);
					} else if(bot.getX() > bot.getBattleFieldWidth()/2) {
						v.pointTo(v.getToX() + bot.getBattleFieldWidth()/4, bot.getBattleFieldHeight()-100);
					} else {
						v.pointTo(v.getToX() - bot.getBattleFieldWidth()/4, bot.getBattleFieldHeight()-100);
					}
				}
            }
                turn = normalizeAngle(v.getBearing()-myHeading);
                if(turn < -Math.PI/2 || turn > Math.PI/2) {
                    movement = -movement;
                    turn = normalizeAngle(turn + Math.PI);
                }
                
                if( turn > 0 ) turn += Math.PI*2/3;
                else turn -= Math.PI*2/3;
            bot.setTurnRightRadians(turn);
            turnDoneTime = bot.getTime() + Math.abs(turn)*180/Math.PI/10*(0.6+Math.random()*0.4);
            double move = movement*Math.random();
            bot.setAhead(move+movement/2);
		}
        
        private void goHitWall(AdvancedRobot bot, HitWallEvent e) {
            boolean reverse = false;
            if(e.getBearing() > -45 && e.getBearing() < 45 && movement > 0) {
                reverse = true;
            } else if(e.getBearing() > 135 || e.getBearing() < -135 && movement < 0) {
                reverse = true;
            }
            double turn = 90-e.getBearing();
            if( turn > 180 ) turn -=180;
            if( turn > 90 ) turn -= 180;
            if( reverse ) {
                bot.setTurnRight(turn);
                movement = -movement;
            }
            else bot.setTurnLeft(turn);
            turnDoneTime = bot.getTime()+Math.abs(turn)/10;
            bot.setAhead(movement);
            //bot.execute();
        }
        
        private void goHitRobot(AdvancedRobot bot, HitRobotEvent e) {
            boolean reverse = false;
            if(e.getBearing() > -90 && e.getBearing() < 90 && movement > 0) {
                reverse = true;
            } else if((e.getBearing() > 90 || e.getBearing() < -90) && movement < 0) {
                reverse = true;
            }
            double turn = 90-e.getBearing();
            if( turn > 180 ) turn -=180;
            if( turn > 90 ) turn -= 180;
            if( reverse ) {
                bot.setTurnRight(turn);
                movement = -movement;
            }
            else bot.setTurnLeft(turn);
            turnDoneTime = bot.getTime()+Math.abs(turn)/10;
            bot.setAhead(movement);
            //bot.execute();
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleBulletHitEvent(AdvancedRobot bot, BulletHitEvent e) {
			if(trackedLife > e.getEnergy()) trackedLife = e.getEnergy();
    		else if(lastTrackedLife > e.getEnergy()) lastTrackedLife = e.getEnergy();
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleBulletMissedEvent(AdvancedRobot bot, BulletMissedEvent e) {
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleCustomEvent(AdvancedRobot bot, CustomEvent e) {
        }
        
        /** Event handler. Keep its execution time short. */
        public void handleDeathEvent(AdvancedRobot bot, DeathEvent e) {
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleHitByBulletEvent(AdvancedRobot bot, HitByBulletEvent e) {
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleHitRobotEvent(AdvancedRobot bot, HitRobotEvent e) {
            hitRobot = e;
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleHitWallEvent(AdvancedRobot bot, HitWallEvent e) {
            hitWall = e;
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleRobotDeathEvent(AdvancedRobot bot, RobotDeathEvent e) {
            trackedName = null;
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleScannedRobotEvent(AdvancedRobot bot, ScannedRobotEvent e) {
            if(trackedName == null || e.getName().equals(trackedName)
            || trackedTime + 5 < bot.getTime()
            || e.getDistance() + bot.getWidth()*2 < trackedPosition.getDistance()){
                trackedPosition.setOrigin(bot.getX(), bot.getY());
                trackedPosition.setBearing(e.getBearingRadians() + bot.getHeadingRadians());
                trackedPosition.setDistance(e.getDistance());
                trackedMovement.setBearing(e.getHeadingRadians());
                trackedMovement.setDistance(e.getVelocity());
                trackedTime=e.getTime();
                trackedName = e.getName();
				lastTrackedLife = trackedLife;
				trackedLife = e.getEnergy();
            }
        }
        
        /** Event handler. Keep its execution time short. */
        public void handleWinEvent(AdvancedRobot bot, WinEvent e) {
        }
        
        /** This should be called by the robot at the start of each battle  */
        public void init(AdvancedRobot bot) {
            movement = 120;
            turnDoneTime = -5;
            dodgeDoneTime = -5;
            if( Math.random() < 0.5 ) movement = -movement;
            hitWall = null;
            hitRobot = null;
            trackedName = null;
            trackedTime = -5;
            bot.setMaxTurnRate(100);
            bot.setMaxVelocity(100);
            bot.out.println("using Weave movement");
        }
    }


