package ags.surreptitious;

import static robocode.util.Utils.normalAbsoluteAngle;
import static robocode.util.Utils.normalRelativeAngle;

import java.util.*;
import ags.surreptitious.info.*;
import ags.util.points.*;
import robocode.*;
import robocode.util.Utils;

public class MiniSurreptitious extends AdvancedRobot {
    private Map<String, EnemyInfo> enemies = new HashMap<String, EnemyInfo>();
    private StatusInfo status = new StatusInfo();
    
    @Override
    public void run() {
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        
        while(true) {
            move();
            fireAt(getTarget());
            turnRadar();
            execute();
        }
    }
    
    AbsolutePoint gGoal;
    /*@Override
    public void onPaint(java.awt.Graphics2D g) {
        RelativePoint r1 = RelativePoint.fromDM(status.velocity.direction+Math.PI/2, 114.55);
        RelativePoint r2 = RelativePoint.fromDM(status.velocity.direction-Math.PI/2, 114.55);
        AbsolutePoint a1 = status.location.addRelativePoint(r1);
        AbsolutePoint a2 = status.location.addRelativePoint(r2);
        
        g.setColor(java.awt.Color.blue);
        g.drawOval((int)a1.x-114, (int)a1.y-114, 229, 229);
        g.drawOval((int)a2.x-114, (int)a2.y-114, 229, 229);
        
        g.setColor(java.awt.Color.green);
        g.fillOval((int)a1.x-2, 18-2, 5, 5);
        g.fillOval((int)a1.x-2, (int)getBattleFieldHeight()-18-2, 5, 5);
        g.fillOval((int)18-2, (int)a1.y-2, 5, 5);
        g.fillOval((int)getBattleFieldHeight()-18-2, (int)a1.y-2, 5, 5);
        g.fillOval((int)a2.x-2, 18-2, 5, 5);
        g.fillOval((int)a2.x-2, (int)getBattleFieldHeight()-18-2, 5, 5);
        g.fillOval((int)18-2, (int)a2.y-2, 5, 5);
        g.fillOval((int)getBattleFieldHeight()-18-2, (int)a2.y-2, 5, 5);
        
        g.setColor(java.awt.Color.red);
        if (gGoal != null)
            g.fillOval((int)gGoal.getX()-2, (int)gGoal.getY()-2, 5, 5);
    }*/
    
    private void move() {
        double bestDanger = Double.POSITIVE_INFINITY;
        RelativePoint bestGoal = null;
        AbsolutePoint momentumPoint = status.location.addRelativePoint(status.velocity);
        AbsolutePoint centerPoint = AbsolutePoint.fromXY(getBattleFieldWidth()/2.0, getBattleFieldHeight()/2.0);
        for (double a=0; a<Math.PI*2; a+=Math.PI/50) {
            for (double d=100; d<300; d+=20) {
                RelativePoint rGoal = RelativePoint.fromDM(a, d);
                AbsolutePoint aGoal = status.location.addRelativePoint(rGoal);
                
                double danger = 0;
                for (EnemyInfo e : enemies.values()) {
                    final double angle = normalAbsoluteAngle(Math.atan2(aGoal.getX()-e.getLocation().getX(), aGoal.getY()-e.getLocation().getY()));
                    final double p = Math.abs(Math.cos(a - angle));
                    final double dist = e.getLocation().distance(aGoal);
                    danger += (1.0+p)/(dist*dist);
                }
                
                danger -= 0.005/(aGoal.distance(momentumPoint));
                
                //double cDist = aGoal.distance(centerPoint)+200;
                //danger += 0.01/(cDist*cDist);
                
                // Add wall dangers. Very small but always discard points that are out of bounds
                danger += 0.0007/Math.pow(Math.max(0, aGoal.getX()-18), 4);
                danger += 0.0007/Math.pow(Math.max(0, aGoal.getY()-18), 4);
                danger += 0.0007/Math.pow(Math.max(0, (getBattleFieldWidth()-aGoal.getX())-18), 4);
                danger += 0.0007/Math.pow(Math.max(0, (getBattleFieldHeight()-aGoal.getY())-18), 4);
                
                if (danger < bestDanger) {
                    bestDanger = danger;
                    bestGoal = rGoal;
                    gGoal = aGoal;
                }
            }
        }
        if (bestGoal != null)
            goToPoint(bestGoal);
    }
    
    public void goToPoint(RelativePoint goal) {
        double turn = goal.getDirDist(status.velocity.direction);
        
        double ahead;
        if (Math.abs(turn) > Math.PI/2) {
            turn = normalRelativeAngle(turn+Math.PI);
            ahead = -goal.getMagnitude();
        } else {
            ahead = goal.getMagnitude();
        }
        
        double maxV = Math.max(0, Math.min(8, (10 - Math.toDegrees(turn/10))/0.75)); 
        double velocity = Math.max(Math.min(maxV, ahead), -maxV);
        
        setAhead(ahead);
        setMaxVelocity(Math.abs(velocity));
        this.setTurnRightRadians(turn);
    }
    
    private void fireAt(EnemyInfo info) {
        if (info == null)
            return;
        RelativePoint rel = RelativePoint.fromPP(status.location, info.getLocation());
        setFire(Math.min(Math.min(this.getEnergy()/6, 1300/rel.magnitude), info.getEnergy()/3));
        setTurnGunRightRadians(Utils.normalRelativeAngle(rel.direction - getGunHeadingRadians()));
    }
    
    private void turnRadar() {
        /*if (getOthers() == 1) {
            for (EnemyInfo e : enemies.values()) {
                if (e.isNew) {
                    RelativePoint rel = RelativePoint.fromPP(status.location, e.getLocation());
                    double turn = normalRelativeAngle(rel.direction-getRadarHeadingRadians());
                    if (turn > 0)
                        turn += Math.PI/5;
                    else
                        turn -= Math.PI/5;
                    setTurnRadarRightRadians(turn);
                    return;
                }
            }
        }*/
        setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    
    private EnemyInfo getTarget() {
        double bestDist = Double.POSITIVE_INFINITY;
        EnemyInfo bestEnemy = null;
        for (EnemyInfo e : enemies.values()) {
            double dist = e.getLocation().distance(status.location);
            if (dist < bestDist) {
                bestDist = dist;
                bestEnemy = e;
            }
        }
        return bestEnemy;
    }
    
    @Override
    public void onStatus(StatusEvent e) {
        RobotStatus s = e.getStatus();
        status.location = AbsolutePoint.fromXY(s.getX(), s.getY());
        status.velocity = RelativePoint.fromDM(s.getHeadingRadians(), s.getVelocity());
        for (EnemyInfo enemy : enemies.values()) {
            enemy.isNew = false;
        }
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyInfo enemy = enemies.get(e.getName());
        if (enemy == null) {
            enemy = new EnemyInfo(e.getName());
            enemies.put(e.getName(), enemy);
        }
        enemy.handleEvent(status, e);
        enemy.isNew = true;
    }
    
    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        enemies.remove(e.getName());
    }
}
