 package t3;
import robocode.*;
//import java.awt.Color;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Ripper - a robot by (RICARDO AND CHAD)
 */
public class Ripper extends AdvancedRobot
{
 double previousEnergy = 100;
  int movementDirection = 1;
  int radarDirection = 1;
  public void run() {
  		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
    setTurnRadarRight(99999);
  }
  public void onScannedRobot(
    ScannedRobotEvent e) {
      // Stay at right angles to the opponent
      setTurnRight(e.getBearing()+90-30*movementDirection);
         
     // If the bot has small energy drop,
    // assume it fired
    double changeInEnergy =
      previousEnergy-e.getEnergy();
    if (changeInEnergy>0 && changeInEnergy<=3) {
         // Dodge!
         movementDirection =-movementDirection;
         setAhead(((e.getDistance()/4+25)*movementDirection)+(Math.random()*20));
     }
    // When a bot is spotted,
	
    // sweep the gun and radar
    radarDirection = -radarDirection;
    setTurnRadarRight(99999*radarDirection);
	double absBearing=e.getBearingRadians()+getHeadingRadians();
	  double latVel=e.getVelocity() * Math.sin(e.getHeadingRadians() -absBearing);
	  double gunTurnAmt = robocode.util.Utils.normalRelativeAngle(absBearing- getGunHeadingRadians()+latVel/10);
	  setTurnGunRightRadians(gunTurnAmt);
   	fire(2);
    // Fire directly at target
    
    
    // Track the energy level
    previousEnergy = e.getEnergy();
  }
  public void onHitByBullet(HitByBulletEvent e){
	  double absBearing=e.getBearingRadians()+getHeadingRadians();
	  double latVel=e.getVelocity() * Math.sin(e.getHeadingRadians() -absBearing);
	  double gunTurnAmt = robocode.util.Utils.normalRelativeAngle(absBearing- getGunHeadingRadians()+latVel/10);
	  setTurnGunRightRadians(gunTurnAmt);
	  
  
	  
  }


	public void onHitWall(HitWallEvent e) {
	ahead(20);
	}	
}


