package rc.yoda.utils;

import robocode.*;
import java.awt.Graphics2D;

/** 
 * Gun - by Robert Codd (Gorded) 
 *
 * This code is here by released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any bot on it)
 *
 * Gun.java : v1.0 -- 2007/05/12
 */ 

/**
 * Gun - A class that defines the
 * events a robocode gun can use
 *
 * @author Robert Codd
 * @version v 1.1
 * @edited 03/04/07
 */
public class Gun
{
	/**
	 * The Advanced Robot this gun is virtually mounted on
	 */	
	protected AdvancedRobot robot;
		
	/**
	 * Class Constructor specifying the robot this 
	 * gun is virtually mounted on
	 */			
	public Gun(AdvancedRobot robot) {	
		this.robot = robot;
	}
	
	/**
	 * onScannedRobot - called by robocode when 
	 * our robot scans the enemy
	 *
	 * @param ScannedRobotEvent - enemy information
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
	}

	/**
	 * onBulletHit - called by robocode when 
	 * one of our bullets hit the enemy
	 *
	 * @param ScannedRobotEvent - enemy information
	 */
	public void onBulletHit(BulletHitEvent e) {	
	}

	/**
	 * onBulletMissed - called by robocode when one of 
	 * our bullets hit a wall
	 *
	 * @param onBulletMissed - missed bullet info
	 */
	public void onBulletMissed(BulletMissedEvent e) {
	}

	/**
	 * onBulletHitBullet - called by robocode when one of 
	 * our bullets hits an enemy bullet
	 *
	 * @param BulletHitBulletEvent - colliding bullet information
	 */
	public void onBulletHitBullet(BulletHitBulletEvent e) {
	}

	/**
	 * onDeath - called by robocode when our robot dies
	 *
	 * @param DeathEvent 
	 */
	public void onDeath(DeathEvent e) {
	}	

	/**
	 * onWin - called by robocode when our robot
	 * wins a round
	 *
	 * @param onWin
	 */
	public void onWin(WinEvent e) {
	}

	/**
	 * onPaint - called by robocode when our 
	 * robot can draw to the screen
	 *
	 * @param Graphic2D - painting tool
	 */
	public void onPaint(Graphics2D g) {
	}

	/**
	 * getFireAngle - called by the gun array to get
	 * the desired firing angle for this gun
	 * angle 0.0: means directly at the enemy
	 */
	public double getFireAngle() {
		return 0.0;
	}

	/**
	 * getBulletPower - called by the gun array to get
	 * the desired bullet power for this gun
	 */
	public double getBulletPower() {
		return 3;
	}
}
