/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;
import robocode.*;
import java.util.Vector;

/* The logger is used to log from specific sources;
 * All sources are logged to system out;
 * Every one of them can be switched on or off;
 */
public class Logger
{
   /* this Vector contains names of all sources
    * from which the input is accepted;
    */
   static private Vector sources = new Vector();
   
   /* the robot from which time will be taken
    */
   static private Robot robot = null;
   
   /* enables logging from specified source
    */
   static public void enable( String sourceName )
   {
      if ( !sources.contains( sourceName ) )
         sources.add( sourceName );
   }
   
   /* disables logging from specified source
    */
   static public void disable( String sourceName )
   {
      sources.remove( sourceName );
   }
   
   /* disables logging from all sources
    */
   static public void disableAll()
   {
      sources.clear();
   }
   
   /* sets the robot, from which the time will be taken;
    * if null, no time will be displayed
    */
   static public void setRobot( Robot robot )
   {
      Logger.robot = robot;
   }
   
   /* logs from specified source;
    * the output string is followed by a line break
    */
   static void log( String sourceName, String text )
   {
      if ( sources.contains( sourceName ) ) {
         if ( robot != null ) { // display time
            System.out.print( "[" );
            System.out.print( Long.toString( robot.getTime() ) );
            System.out.print( "]" );
         }
         System.out.print( "<" );
         System.out.print( sourceName );
         System.out.print( "> " );
         System.out.println( text );
      }
   }
   
}
   
