package shinh;

import robocode.*;

/// for melee
public class MoveAntiGrav4 extends Move implements Const {
	private EnemyMgr emgr_;

	private int changeTurn_ = 0;

	private double aimXU_ = 400;
	private double aimXD_ = 400;
	private double aimYR_ = 300;
	private double aimYL_ = 300;
	private double aimXUPnt_;
	private double aimXDPnt_;
	private double aimYRPnt_;
	private double aimYLPnt_;
	private int aimCount_ = 0;

	public void use() {
		changeTurn_ = 0;
	}

	public String name() {
		return "antigrav4";
	}

	public MoveAntiGrav4() {
		init();
	}

	public void init() {
		ent = Entangled.me;
		emgr_ = ent.emgr;
	}

	public double getGravPower(double px, double py) {
		double ret = 0;
		double rn;

		for (int i = 0; i < emgr_.size(); i++) {
			Enemy enemy = emgr_.get(i);
			rn =
				3.0 /
				(Util.distance2(px, py, enemy.x, enemy.y) * ent.getOthers());
			ret += rn;
		}

		double x = px - ent.lastHitX;
		double y = py - ent.lastHitY;
		rn = GRAV_LASTHIT_PER_ENEMY / (x*x + y*y);
		ret += rn;

		return ret;
	}

	public void updateAim() {
		double pnt;

		if (aimCount_ == 0) {
			double x = Math.random() * ent.fieldW;
			aimXUPnt_ = getGravPower(aimXU_, ent.fieldH);
			pnt = getGravPower(x, ent.fieldH);
			if (pnt < aimXUPnt_) {
				aimXU_ = x;
				aimXUPnt_ = pnt;
			}
		}
		else if (aimCount_ == 1) {
			double x = Math.random() * ent.fieldW;
			aimXDPnt_ = getGravPower(aimXD_, 0);
			pnt = getGravPower(x, 0);
			if (pnt < aimXDPnt_) {
				aimXD_ = x;
				aimXDPnt_ = pnt;
			}
		}
		else if (aimCount_ == 2) {
			double y = Math.random() * ent.fieldH;
			aimYRPnt_ = getGravPower(ent.fieldW, aimYR_);
			pnt = getGravPower(ent.fieldW, y);
			if (pnt < aimYRPnt_) {
				aimYR_ = y;
				aimYRPnt_ = pnt;
			}
		}
		else {
			double y = Math.random() * ent.fieldH;
			aimYLPnt_ = getGravPower(0, aimYL_);
			pnt = getGravPower(0, y);
			if (pnt < aimYLPnt_) {
				aimYL_ = y;
				aimYLPnt_ = pnt;
			}
		}

		aimCount_ = (aimCount_ + 1) & 3;

/*
		ent.out.println("" + aimXD_ + ": " + aimXDPnt_ + "\n" +
						aimXU_ + ": " + aimXUPnt_ + "\n" +
						aimYL_ + ": " + aimYLPnt_ + "\n" +
						aimYR_ + ": " + aimYRPnt_ + "\n");
*/
	}

	public void update() {
		updateAim();

		double ev = ent.getVelocity() * 0.5;
		ev = ev * (ev + 1);
		double ex = ent.getX() + ev * Math.sin(ent.getHeadingRadians());
		double ey = ent.getY() + ev * Math.cos(ent.getHeadingRadians());

		if (ent.nearEdge(50)) {
			changeTurn_ = 0;
		}
		else {
			for (int i = 0; i < ent.emgr.size(); i++) {
				if (ent.emgr.get(i).distance < 100) {
					changeTurn_ = 0;
					break;
				}
			}
		}

		changeTurn_--;
		if (changeTurn_ > 0) {
			return;
		}

		changeTurn_ = 3 + (int)(Math.random() * 4);

		double forceX = 0;
		double forceY = 0;

		for (int i = 0; i < emgr_.size(); i++) {
			Enemy enemy = emgr_.get(i);
			double rn =
				10.0 / (Math.pow(enemy.distance, GRAV_ENEMY_POW) *
					   ent.getOthers());
			double x = ex - enemy.x;
			double y = ey - enemy.y;
			forceX += x * rn;
			forceY += y * rn;
		}

		for (int i = 0; i < ent.bmgr.size(); i++) {
			EnemyBullet eb = ent.bmgr.getBullet(i);
			double rn = 1 /
				Math.pow(Util.distance(ex, ey,
									   eb.x, eb.y), GRAV_BULLET_POW);
			double x = ex - eb.x;
			double y = ey - eb.y;
			forceX += x * rn;
			forceY += y * rn;
		}

		double x, y, rn;

		if (ent.getOthers() > 1) {
			x = ex - ent.fieldW_2;
			y = ey - ent.fieldH_2;
			rn = GRAV_CENTER_PER_ENEMY / (x*x + y*y);
			forceX += x * rn;
			forceY += y * rn;
		}

		int afterHitTurn = (int)(ent.getTime() - ent.lastHitTurn);
		if (afterHitTurn < 20) {
			x = ex - ent.lastHitX;
			y = ey - ent.lastHitY;
			rn = GRAV_LASTHIT_PER_ENEMY / (x*x + y*y) *
				(20 - afterHitTurn) / 20;
			forceX += x * rn;
			forceY += y * rn;
		}

		if (ent.getOthers() < 8) {
			x = Math.abs(ex - aimXD_);
			y = ey;
			rn = GRAV4_AIM_RATIO /
				(x*Math.sqrt(x) + y*Math.sqrt(y)) / aimXDPnt_;
			forceX -= x * rn;
			forceY -= y * rn;

			x = Math.abs(ex - aimXU_);
			y = ent.fieldH - ey;
			rn = GRAV4_AIM_RATIO /
				(x*Math.sqrt(x) +y*Math.sqrt(y)) / aimXUPnt_;
			forceX -= x * rn;
			forceY -= y * rn;

			x = ex;
			y = Math.abs(ey - aimYL_);
			rn = GRAV4_AIM_RATIO /
				(x*Math.sqrt(x) +y*Math.sqrt(y)) / aimYLPnt_;
			forceX -= x * rn;
			forceY -= y * rn;

			x = ent.fieldW - ex;
			y = Math.abs(ey - aimYR_);
			rn = GRAV4_AIM_RATIO /
				(x*Math.sqrt(x) +y*Math.sqrt(y)) / aimYRPnt_;
			forceX -= x * rn;
			forceY -= y * rn;
		}

		forceX += 
			GRAV_WALL_PER_ENEMY /
			Math.pow(Math.abs(ex-WALL_AVOID_INTERVAL), GRAV_WALL_POW);
		forceX -=
			GRAV_WALL_PER_ENEMY /
			Math.pow(Math.abs(ex-ent.fieldW+WALL_AVOID_INTERVAL),
					 GRAV_WALL_POW);
		forceY +=
			GRAV_WALL_PER_ENEMY /
			Math.pow(Math.abs(ey-WALL_AVOID_INTERVAL), GRAV_WALL_POW);
		forceY -=
			GRAV_WALL_PER_ENEMY /
			Math.pow(Math.abs(ey-ent.fieldH+WALL_AVOID_INTERVAL),
					 GRAV_WALL_POW);

		// keep linear formation
/*
		if (ent.getOthers() < 11) {
			for (int i = 0; i < emgr_.size(); i++) {
				double x1 = emgr_.get(i).x;
				double y1 = emgr_.get(i).y;
				for (int j = i+1; j < emgr_.size(); j++) {
					double x2 = emgr_.get(j).x;
					double y2 = emgr_.get(j).y;
					double dx = x2 - x1;
					double dy = y2 - y1;

					double xp, yp;
					boolean outer;
					if (dx == 0) {
						xp = x1;
						yp = ey;
						outer = (yp > y1 && yp > y2) || (yp < y1 && yp < y2);
					}
					else if (dy == 0) {
						xp = ex;
						yp = y1;
						outer = (xp > x1 && xp > x2) || (xp < x1 && xp < x2);
					}
					else {
						double dy_dx = dy / dx;
						double dx_dy = dx / dy;
						double b1 = y2 - dy_dx * x2;
						double b2 = ey + dx_dy * ex;
						xp = (b2-b1)/(dy_dx+dx_dy);
						yp = dy_dx * xp + b1;
						double d1 = Util.distance2(x1, y1, x2, y2);
						double d2 = Util.distance2(x1, y1, xp, xp);
						double d3 = Util.distance2(xp, yp, x2, y2);
						outer = (d2 > d1) || (d3 > d1);
					}

					if (xp < 0 || xp > ent.fieldW || yp < 0 || yp > ent.fieldH)
						continue;

					x = ex - xp;
					y = ey - yp;
					rn = ((outer) ? -0.5 : 1) * GRAV_LINEAR_PER_ENEMY /
						((x*x + y*y) * ent.getOthers());
					forceX += x * rn;
					forceY += y * rn;
				}
			}
		}
*/

		if (ent.target != null) {
			double r = ent.target.radian +
				((Math.random() < 0.5) ? 1 : -1) * Const.PI_2;
			forceX += 0.02 * Math.sin(r);
			forceY += 0.02 * Math.cos(r);
		}

/*
		if (ent.target != null) {
			double r = ent.target.radian + Const.PI_2;
			double dx = 0.02 * Math.sin(r);
			double dy = 0.02 * Math.cos(r);
			double fx1 = forceX + dx;
			double fy1 = forceY + dy;
			double fx2 = forceX - dx;
			double fy2 = forceY - dy;
			if (Util.length2(fx1, fy1) > Util.length2(fx2, fy2)) {
				forceX = fx1;
				forceY = fy1;
			}
			else {
				forceX = fx2;
				forceY = fy2;
			}
		}
*/
		double trans = Util.getNormalRadian(
			Math.atan2(forceX, forceY) -
			Util.getNormalRadian(ent.getHeadingRadians()));

		goRadian(trans);
	}

}

