package shinh;

import robocode.*;

import java.awt.geom.Point2D;

public class MoveJigglingEdge extends Move {
	private Point2D.Double aimPnt_;
	private Point2D.Double aimPnts_[];

	private int step = 0;

	public String name() {
		return "jiggling edge";
	}

	public MoveJigglingEdge() {
		init();
		aimPnts_ = new Point2D.Double[4];
   	}

	public void init() {
		ent = Entangled.me;
	}

	public void use() {
		step = 0;
		if (ent.getX() > ent.fieldW_2) {
			if (ent.getY() > ent.fieldH_2) {
				aimPnts_[0] =
					new Point2D.Double(ent.fieldW - 70, ent.fieldH - 70);
				aimPnts_[1] =
					new Point2D.Double(ent.fieldW - 210, ent.fieldH - 60);
				aimPnts_[2] =
					new Point2D.Double(ent.fieldW - 70, ent.fieldH - 70);
				aimPnts_[3] =
					new Point2D.Double(ent.fieldW - 60, ent.fieldH - 210);
			}
			else {
				aimPnts_[0] =
					new Point2D.Double(ent.fieldW - 70, 70);
				aimPnts_[1] =
					new Point2D.Double(ent.fieldW - 210, 60);
				aimPnts_[2] =
					new Point2D.Double(ent.fieldW - 70,  70);
				aimPnts_[3] =
					new Point2D.Double(ent.fieldW - 60, 210);
			}
		}
		else {
			if (ent.getY() > ent.fieldH_2) {
				aimPnts_[0] =
					new Point2D.Double(70, ent.fieldH - 70);
				aimPnts_[1] =
					new Point2D.Double(210, ent.fieldH - 60);
				aimPnts_[2] =
					new Point2D.Double(70, ent.fieldH - 70);
				aimPnts_[3] =
					new Point2D.Double(60, ent.fieldH - 210);
			}
			else {
				aimPnts_[0] =
					new Point2D.Double(70, 70);
				aimPnts_[1] =
					new Point2D.Double(210, 60);
				aimPnts_[2] =
					new Point2D.Double(70, 70);
				aimPnts_[3] =
					new Point2D.Double(60, 210);
			}
		}
		aimPnt_ = aimPnts_[0];
	}

	public boolean isValid() {
		if (ent.getOthers() < 3) return false;

		for (int i = 0; i < ent.emgr.size(); i++) {
			if (ent.emgr.get(i).distance < 70) return false;
		}

		Point2D.Double p;
		if (ent.self.x > ent.fieldW_2) {
			if (ent.self.y > ent.fieldH_2) {
				p = new Point2D.Double(ent.fieldW, ent.fieldH);
			}
			else {
				p = new Point2D.Double(ent.fieldW, 0);
			}
		}
		else {
			if (ent.self.y > ent.fieldH_2) {
				p = new Point2D.Double(0, ent.fieldH);
			}
			else {
				p = new Point2D.Double(0, 0);
			}
		}

		double ed = Util.distance2(p.x, p.y, ent.self.x, ent.self.y);

		if (ed > 250000) return false;

		ed *= 1.2;

		for (int i = 0; i < ent.emgr.size(); i++) {
			Enemy e = ent.emgr.get(i);
			double d = Util.distance2(p.x, p.y, e.x, e.y);
			if (ed > d || d < 40000) return false;
		}

		return true;
	}

	public void update() {
		if (Util.distance2(aimPnt_.x, aimPnt_.y, ent.self.x, ent.self.y)
			< 40) {
			step = (step + 1) & 7;

			int s = step >> 1;
			if (step == 1 || step == 5) {
				double mx = 10000, my = 10000;
				for (int i = 0; i < ent.emgr.size(); i++) {
					Enemy e = ent.emgr.get(i);
					double dx = Math.abs(aimPnt_.x - e.x);
					double dy = Math.abs(aimPnt_.y - e.y);
					if (dx < 100) {
						if (my > dy) {
							my = dx + dy;
						}
					}
					if (dy < 100) {
						if (mx > dx) {
							mx = dx + dy;
						}
					}
				}

				if (mx < 500 || my < 500) {
					if (mx < my && step == 1) {
						step = 5;
						s = step >> 1;
					}
					else if (my < mx && step == 5) {
						step = 1;
						s = step >> 1;
					}
				}
			}

			if ((step & 1) == 1) {
				double x = aimPnts_[s].x;
				double y = aimPnts_[s].y;
				s = (s + 1) & 3;
				double r = Math.random();
				x = x * r + aimPnts_[s].x * (1-r) + Math.random()*20 - 10;
				y = y * r + aimPnts_[s].y * (1-r) + Math.random()*20 - 10;
				aimPnt_ = new Point2D.Double(x, y);
			}
			else {
				aimPnt_ = aimPnts_[s];
			}
		}
		else if (Math.random() < 0.01) {
			step = (int)(Math.random()*8);
			aimPnt_ = aimPnts_[step >> 1];
		}

		double forceX = 0;
		double forceY = 0;

		double ex = ent.getX();
		double ey = ent.getY();

		double x = ex - aimPnt_.x;
		double y = ey - aimPnt_.y;
		double rn = 3 / (x*x + y*y);
		forceX -= x * rn;
		forceY -= y * rn;

		for (int i = 0; i < ent.bmgr.size(); i++) {
			EnemyBullet eb = ent.bmgr.getBullet(i);
			rn = 1 / Util.distance2(ex, ey, eb.x, eb.y);
			x = ex - eb.x;
			y = ey - eb.y;
			forceX += x * rn;
			forceY += y * rn;
		}

		double trans = Util.getNormalRadian(
			Math.atan2(forceX, forceY) -
			Util.getNormalRadian(ent.getHeadingRadians()));

		goRadian(trans);
		//goPoint(aimPnt_);
	}

}

