package dft;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Vector;

import robocode.*;
import dft.bin.*;

public class Immortal extends AdvancedRobot {
	
	private boolean isTC = false; 
	
	public void run() {
		
		setColors(new Color(0,0,0),new Color(0,0,0),new Color(0,0,0));
		
		waves.clear();
		enemyWaves.clear();
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		current = new State(this);
		
		Utils.battleField = new Rectangle2D.Double(18,18,getBattleFieldWidth()-36,getBattleFieldHeight()-36);
		
		setTurnRadarRight(360);
		
		while (true) {
			if (current.getTime()>-1) {
				if (getOthers() > 0) waves.update(current);	
				enemyWaves.update(current);
				if (getOthers() > 0) gun.think(waves,current,log);	
				move.think(enemyWaves,current,log);
			}
			
			if (getTime()-current.getTime() > 8)
				setTurnRadarRight(360);
			execute();
		}
	}
	
	private BASIC gun = new BASIC();
	private COBOL move = new COBOL();
	
	private State current;	
	private Log log = new Log();
	private WaveManager waves = new WaveManager();
	private WaveManager enemyWaves = new WaveManager();
	
	
	public void onPaint(Graphics2D g) {	
		move.onPaint(g);
		//waves.onPaint(g);
		//enemyWaves.onPaint(g);
		
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		current.onRobotDeath(e);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		
		log.update(current);
		
		setTurnRadarRightRadians(Math.tan(e.getBearingRadians()
				+getHeadingRadians()-getRadarHeadingRadians())*2.4);	
		//if (current.getTime()==-1)
		//	System.out.println("INIT: " + e.getDistance());
		current.onScannedRobot(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		
		move.onHitByBullet(e);
	//System.out.println("    "+current.getEnemyDistance() + " (" + getTime()+")");
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		move.onBulletHitBullet(e);
	}
	
	// Statistics, mostly just outputted	
	static int wins = 0;	
	public void onWin(WinEvent e) {
		roundOver("WIN");
	}
	public void onDeath(DeathEvent e) {
		roundOver("LOSS");		
		Iterator i = getAllEvents().iterator();
		while(i.hasNext()) {
			Event n = (Event)i.next();
			if (n instanceof HitByBulletEvent)
				move.onHitByBullet((HitByBulletEvent)n);
		}
	}
	public void roundOver(String result) {
		if (result.equals("WIN")) {
			wins++;
		}
		System.out.println("W/L: " + wins + "-" + (getRoundNum()+1-wins));
		System.out.println("---");
		System.out.println("RND: " + rHit/(rMiss+rHit)*100+"%");
		System.out.println("TOT: " + tHit/(tMiss+tHit)*100+"%");		
	}	
	
	static double tHit, tMiss;
	double rHit, rMiss;
	
	public void onBulletHit(BulletHitEvent e) {		
		current.onBulletHit(e);
		gunStatUpdate("HIT");
	}
		
	public void onBulletMissed(BulletMissedEvent e) {
		if (getOthers() > 0) gunStatUpdate("MISS");
	}
		
	public void gunStatUpdate(String result) {		
		if (result.equals("HIT")) {
			rHit++; tHit++;
		}
		else {
			tMiss++; rMiss++;
		}
	}
	
}
