package DM;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import robocode.util.Utils;
import java.util.Random;

/**
 * Chicken - a robot by Damij
 */
public class Chicken extends TeamRobot
{
Enemy enemy = new Enemy();
Cap Circle= new Cap();
public static double bPower;
double timeOfShot;
static double timeOfHit;
static double headingPlus;
double countdown;
static int direction = 1;
double radarOffset;
final double PI = Math.PI;
final double waitTime = 10;
static int shots;
static int hits;
static double fieldWidth;
static double fieldHeight;
static long currTime;
static long nextTimeToHit;
static double heading;
private RoundRectangle2D.Double playField; // the playable battlefield
private final static int WALLAVOID = 50;	// the area to avoid near walls
public static double WALL_STICK = 160;
public static long nextTime;
Point2D.Double p;
Random headPlus = new Random();
public static long nextTimeNeededToHit;

	/**
	 * run: Chicken's default behavior
	 */
int in = 0;
	public void run() {
		
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);


		//PURPLE AND WHITE GO KAHOKS
		setColors(new Color(139,63,169),new Color(139,63,69),Color.white);
		enemy.health = 100;
		setTurnRadarRight(360);
		
		fieldWidth = getBattleFieldWidth();
		fieldHeight = getBattleFieldHeight();
		
		playField = new RoundRectangle2D.Double( WALLAVOID, WALLAVOID,
	    fieldWidth - 2 * WALLAVOID, fieldHeight - 2 * WALLAVOID, 50, 50);
	
		if(getOthers()>1||enemy.RepetitionGun==false)
		enemy.speedChanges=0;;
		
		enemy.distance = 1000000;
		
		turnRadarRightRadians(2*PI);
		
		heading = getHeading();
		
		execute();
		
		while(true) {
			
			enemy.currTime = getTime();
			
			setTurnRadarRight(Double.POSITIVE_INFINITY);
			
						
			enemy.currTime = getTime();
			
			doRadar();
			doGun();
			checkMovement();			

			execute();
			
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if ((e.getDistance() < enemy.distance)||(enemy.name == e.getName())||(enemy.name == null) && isTeammate(e.getName())==false) {
			enemy.name = e.getName();
			enemy.distance = e.getDistance();
			enemy.health = e.getEnergy();
			enemy.speed = e.getVelocity();
			enemy.x = getX() + (Math.sin(getHeadingRadians() + e.getBearingRadians()) * e.getDistance());
			enemy.y = getY() + (Math.cos(getHeadingRadians() + e.getBearingRadians()) * e.getDistance());
			
			enemy.lastSpeedO = enemy.speedO;
			
			enemy.update();
			
			if(enemy.lastSpeedO!=enemy.speedO){
			enemy.speedChanges++;
			enemy.speedChangeTime = getTime();
			enemy.speedChangeTimeDif = enemy.speedChangeTime - enemy.lastSpeedChangeTime;
			enemy.avgSpeedChangeTime = (enemy.avgSpeedChangeTime+enemy.speedChangeTimeDif)/2;
			enemy.nextSpeedChangeTime = Math.round(enemy.avgSpeedChangeTime + enemy.speedChangeTime);
			enemy.lastSpeedChangeTime = getTime();
			}
			
			double absbearing_rad = (getHeadingRadians()+e.getBearingRadians())%(2*PI);
			double h = NormaliseBearing(e.getHeadingRadians() - enemy.head);
			h = h/(getTime() - enemy.ctime);
			enemy.changehead = h;
			enemy.bearing = e.getBearingRadians();
			enemy.head = e.getHeadingRadians();
			enemy.ctime = getTime();				//game time at which this scan was produced
			
			//bPower = Math.round((4/enemy.speed + getBattleFieldHeight()/enemy.distance + getEnergy()/e.getEnergy()*2)/3);
			if(enemy.RepetitionGun==false)
			bPower = 1.1;
			else{
			bPower = 3;}
			if(bPower==Double.POSITIVE_INFINITY)
			bPower = 3;
		
		if(enemy.distance<250){
			if(direction==1)
				headingPlus = 15;
			else{
				headingPlus = -15;
			}
		}
		else if(enemy.distance>265){
			if(direction==1)
				headingPlus = -15;
			else{
				headingPlus = 15;
			}
		}
		
		if(e.getBearing()>0)
		setTurnRight((e.getBearing() - 90) - headingPlus);
		else if(e.getBearing()<=0)
		setTurnRight((e.getBearing() + 90) + headingPlus);


		if ((getGunHeat() == 0.0)&&(getEnergy() > bPower)) {
			setFire(bPower);
		}
	}
		else{
			return;
		}
	}
	void doGun() {
		p = new Point2D.Double(enemy.x, enemy.y);

       		nextTimeNeededToHit = (int)Math.round((getrange(getX(),getY(),p.x,p.y)/(20-(3*bPower))));
			nextTimeToHit = nextTimeNeededToHit + getTime();
        	p = enemy.guessPosition(nextTimeNeededToHit);

		double gunOffset = getGunHeadingRadians() - (Math.PI/2 - Math.atan2(p.y - getY(),p.x -  getX()));
		if(p.x!=0)				//If we didn't just reset the grid
		setTurnGunLeftRadians(NormaliseBearing(gunOffset));
	}
	void doRadar()
		{
			if(getTime() - enemy.ctime > 4){
				radarOffset = 4*PI;
			}
			else{
			radarOffset = getRadarHeadingRadians() - (Math.PI/2 - Math.atan2(enemy.y - getY(),enemy.x - getX())); 

			radarOffset = NormaliseBearing(radarOffset);
			if (radarOffset < 0)
				radarOffset -= PI/10;
			else {
				radarOffset += PI/10; 
		}
	}
		setTurnRadarLeftRadians(radarOffset);
	}
	void checkMovement()
		{

			if(enemy.shot){
				timeOfShot = getTime();
				double bulletSpeed = 20 - (3 * (enemy.healthDif * -1));
				double timeTillHit = enemy.distance/bulletSpeed;
				timeOfHit = (timeOfShot + timeTillHit) - 8;
				//System.out.println("distance " + enemy.distance + "   bSpeed " + bulletSpeed + "   time " + timeOfShot + "\nTime of Hit: " + timeOfHit + "   Time " + getTime());
				enemy.update();
			}
			
			countdown = timeOfHit - getTime();
			enemy.timeTillNextSpeedChange = enemy.nextSpeedChangeTime - getTime();
			wallAvoidance();
			//out.println(countdown);

			if(countdown < 20 && enemy.shot){ 
				setAhead(70*direction);
			}
			if(countdown < 0 && enemy.shot == true){ enemy.shot = false;}
		}
	
	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//out.println("Hit at " + getTime());
	}
	public void onHitWall(HitWallEvent e){
		reverse();
	}
	public void onHitRobot(HitRobotEvent e){
		reverse();
	}
	public void onRobotDeath(RobotDeathEvent e){
		if(e.getName() == enemy.name)
			enemy.name = null;
		}
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180)
			return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -180)
			fixedAngle += 360;
		while (fixedAngle > 180)
			fixedAngle -= 360;
		return fixedAngle;
	}
	double NormaliseBearing(double ang) {
		if (ang > PI)
			ang -= 2*PI;
		if (ang < -PI)
			ang += 2*PI;
		return ang;
	}
	public double getrange( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = Math.sqrt( xo*xo + yo*yo );
		return h;	
	}
	public void reverse(){
		direction *= -1;
	}
	public void wallAvoidance() {
        if(!playField.contains(getX(),getY())&&enemy.angChangeTimes==0) {
			direction*=-1;
			enemy.angChangeTimes++;
			execute();
        }
		else if(playField.contains(getX(),getY())){
			enemy.angChangeTimes=0;
		}
    }

}

class Enemy{

	static String name;
	static double distance;
	static double speed;
	static boolean shot;
	static double health;
	static double lastHealth;
	static double healthDif;
	static long currTime;
	static long lastTime;
	static double x;
	static double y;
	public double bearing;
	public double head;
	public long ctime;                 //game time that the scan was produced
	public double changehead;
	public double angChangeTimes;
	public double diff;
	public static boolean RepetitionGun;
	static double oldSpeed;
	static double speedDif;
	static double speedChanges;
	static int speedPoNe;				//PoNe = Positive/Negative
	static int speedO;
	static int lastSpeedO;
	static long speedScanTime;
	static long speedScanTimeDif;
	static long lastSpeedScanTime;
	static int numSpeedScans;
	static int gunScanTimes;
	static long lastSpeedChangeTime;
	static long speedChangeTime;
	static long speedChangeTimeDif;
	static double avgSpeedChangeTime;
	static double nextSpeedChangeTime;
	static double timeTillNextSpeedChange;
	static double timeOfGunScan;
	static double timeSinceGunScan;
	static double numGunScans;
	static double xChange;
	static double yChange;
	static double yTSlope;
	static double xTSlope;
	static double oldY;
	static double oldX;
	static double ySlopeT;
	static double xSlopeT;
	static double newRelativeY;
	static double newRelativeX;
	
	
	public Point2D.Double guessPosition(long when){

		double newY = 0;
		double newX = 0;

		if(RepetitionGun==false){
		if(numGunScans%6==0||numGunScans==0){
			timeOfGunScan = currTime;
			oldX = x;
			oldY = y;
			newX = 0;
			numGunScans++;
		}

		else{
			timeSinceGunScan = currTime - timeOfGunScan;
			yChange = y - oldY;
			xChange = x - oldX;
			ySlopeT = yChange/timeSinceGunScan;
			xSlopeT = xChange/timeSinceGunScan;
			newRelativeX = xSlopeT * when;
			newRelativeY = ySlopeT * when;
			newY = y + newRelativeY;
			newX = x + newRelativeX;
			numGunScans++;
		}
	}
	else{
		newY = y;
		newX = x;
	}
		
		return new Point2D.Double(newX, newY);
	}
		public static void update(){
			if(currTime != lastTime){
				lastTime = currTime;
			}
				
				if(healthDif != 0)
					healthDif = 0;
				
				if(lastHealth != health){
					healthDif = health - lastHealth;
					lastHealth = health;
				
				if(healthDif < 0 && healthDif >= -3){
					shot = true;
				}
				else{
					shot = false;
				}
			  }
			  else{
				healthDif = 0;
			}
			
			if(speed != oldSpeed){
				if(speed>0){
					speedDif = speed - oldSpeed;
					if(speedDif>0)speedPoNe = 1;				//speeding up
					else if(speedDif<0)speedPoNe = -1;			//slowing down
					speedO = 1;

					numSpeedScans+=1;
					speedScanTime = currTime;
					speedScanTimeDif = speedScanTime - lastSpeedScanTime;
					lastSpeedScanTime = speedScanTime;

					speedScanTimeDif = currTime - lastSpeedScanTime;
					if(speedScanTime<450&&speedChanges>5&&(Chicken.nextTimeToHit)>timeTillNextSpeedChange){
						RepetitionGun = true;
					}
					else{RepetitionGun = false;
					speedChanges = 0;
					numSpeedScans=0;}
				}
				else if(speed<0){
					speedDif = speed - oldSpeed;
					if(speedDif>0)speedPoNe = -1;				//slowing down
					else if(speedDif<0)speedPoNe = 1;				//speeding up
					speedO = -1;
					
					numSpeedScans+=1;
					speedScanTime = currTime;
					speedScanTimeDif = speedScanTime - lastSpeedScanTime;
					lastSpeedScanTime = speedScanTime;
					
					speedScanTimeDif = currTime - lastSpeedScanTime;
					if(speedScanTimeDif<450&&speedChanges>5&&(Chicken.nextTimeToHit)>timeTillNextSpeedChange){
						RepetitionGun = true;
					}
					else{RepetitionGun = false;
					speedChanges= 0;
					numSpeedScans=0;}
				}
		}
		}
		
	}
