package ags.utils.kdtree;

import java.util.Comparator;

/**
 * @author Alexander Schultz
 */
class DistanceComparator implements Comparator<KDEntry> {
    private final HyperPoint origin;
    
    public DistanceComparator(HyperPoint o) {
        origin = o;
    }
    
    public int compare(KDEntry o1, KDEntry o2) {
        double dist1 = o1.getPosition().sqrDist(origin);
        double dist2 = o2.getPosition().sqrDist(origin);
        return Double.compare(dist1, dist2);
    }

}
