package bvh.hdr;

import robocode.*;
import java.awt.geom.Point2D;
/**********************************************************************
** BEGIN CLASS DOEL
**********************************************************************/
/**
 * Doel - deze class bevat zoveel mogelijk informatie over het doel:
 *
 * Deze class wordt gebruikt om gescande tegenstanders op te slaan en
 * om het huidig doel vast te leggen.
 *
 * to do: doel en kogel laten overerven van gemeenschappelijk "inkomend" object.
 */
class Doel implements Constanten {

/**********************************************************************
** definitie variabelen:
**********************************************************************/
   public         String               naam;
   public  static Point2D.Double       positie;
   public  static double               bewegingsrichting, richting, afstand, v, e;
   public  static long                 scanTijd; //tijd waarop doel is gescanned

/**********************************************************************
** Constructor:
**********************************************************************/
   public Doel() {
      naam        = null;
      positie     = new Point2D.Double(200,200); // initiele aanname, bijwerken wanneer mogelijk.
      e           = 100; // initiele waarde, bijwerken wanneer mogelijk.
      v           = 6;   // initiele aanname, bijwerken wanneer mogelijk.
      afstand     = 400; // initiele aanname, bijwerken wanneer mogelijk.
      scanTijd    = -100;// initeel negatief: nog niet gescanned.
   }

   public void setAfstand(double afstand) {
      this.afstand = afstand;
   }

   public void setPositie(Point2D.Double pos) {
      this.positie.setLocation(pos.getX(), pos.getY());
   }

/**
* Methode voor bepalen of doel-info is verouderd.
*/
   public boolean isInfoActueel(long nu) {
      if ( (nu-scanTijd)>LANGEPROBEERTIJD )
         return (false);
      else
         return (true);
   }

/**********************************************************************
** methoden voor bijhouden info doel:
**********************************************************************/
/**
* Methode voor bijwerken doel-info:
* 1) info obv. inslag kogel van de tegenstander
*/
   public void setInfo(HitByBulletEvent evt, AdvancedRobot bot) {
      naam                = evt.getName();
      scanTijd            = bot.getTime();
                            // Hodur zal de afname van energie meestal missen, maar deze is af te leiden...
      e                  -= (20-evt.getVelocity())/3D; // v=20-3*de <-> de=(20-v)/3;
      richting            = PI+evt.getHeadingRadians();
//      richting            = Utils.normalRelativeAngle(bot.getHeadingRadians() + evt.getBearingRadians());
      bewegingsrichting   = richting + PI/4D;
      if (afstand < 2*BOTGROOTTE || afstand > 1.5*STANDAARDSTRAAL)
         afstand = STANDAARDSTRAAL;
      positie.setLocation( bot.getX() + afstand * Math.sin( richting )
                         , bot.getY() + afstand * Math.cos( richting ));
   }
/**
* Methode voor bijwerken doel-info:
* 1) info obv. inslag eigen kogel in de tegenstander
*/
   public void setInfo(BulletHitEvent evt, Hodur bot)
   {
      Bullet kogel        = evt.getBullet();

      naam                = evt.getName();
      scanTijd            = bot.getTime();
      // een exacte bepaling van de energie is mogelijk!
      e                   = evt.getEnergy(); 
      richting            = kogel.getHeadingRadians();
      bewegingsrichting   = richting + PI/4D;
      positie.setLocation( kogel.getX()
                         , kogel.getY());
// afstand niet bijwerken: dan is deze niet meer bruikbaar i.g.v. lineaire bewegingsschatter.                         
      afstand             = new Point2D.Double( bot.getX()
                                              , bot.getY()).distance(positie);

   }
/**
* 3) info obv. botsing met tegenstander
*/
   public void setInfo(HitRobotEvent evt, Hodur bot) {
      naam                = evt.getName();
      scanTijd            = bot.getTime();
      // een exacte bepaling van de energie is mogelijk!
      e                   = evt.getEnergy(); 
      richting            = bot.getHeadingRadians() + evt.getBearingRadians();
      bewegingsrichting   = richting + PI/4D;
      positie.setLocation( bot.getX() + 36D * Math.sin( richting )
                         , bot.getY() + 36D * Math.cos( richting ));
// afstand niet bijwerken: dan is deze niet meer bruikbaar i.g.v. lineaire bewegingsschatter.                         
      afstand             = new Point2D.Double( bot.getX()
                                              , bot.getY()).distance(positie);

   }
/**********************************************************************
*  DOEL RICHTING SCHATTERS
**********************************************************************/
/**
* LineaireDoelRichtingVoorspelling: berekend de verwachte Doel bearing op tijd T+deltaT
*    o.b.v. snelheid kogel, (x,y)Robot, (x,y)Doel, Doel bearing, Doel heading
*    en de Robot heading
*    Directe berekening (zie aantekeningen).
*
* v0.1 (27-08-2002)
*/

   public double lineaireBewegingsSchatter(double xBot, double yBot, long tijd, double vKogel)
   {
      int    t;
      double xSchat = 0;
      double ySchat = 0;
      double dSchat = afstand;
      if (dSchat < 2*BOTGROOTTE || dSchat > 1.5*STANDAARDSTRAAL)
         dSchat = STANDAARDSTRAAL;
      
      for (int i = 0; i < 4; i++){ // iteratie om afstand tot doel te schatten (geen wijziging
                                   // in resultaat na 4 iteraties (getest tegen spinbot)))
         t = (int)(Math.round(dSchat/vKogel) + (tijd - scanTijd) + 1);
         xSchat = positie.x + Math.sin(bewegingsrichting) * v * t;
         ySchat = positie.y + Math.cos(bewegingsrichting) * v * t;
         dSchat = new Point2D.Double(xSchat,ySchat).distance(new Point2D.Double(xBot,yBot));
      }
// controleer of doel-positie niet buiten slagveld wordt geschat:
      return ( RoboUtils.bepaalRichting( new Point2D.Double(xSchat,ySchat)
                                       , new Point2D.Double(xBot,yBot) ) );
   }

}
/**********************************************************************
** EINDE CLASS DOEL
**********************************************************************/
