package cs.s2;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import cs.s2.misc.Tools;

import robocode.*;

public abstract class Extension {
	protected Seraphim bot;
	/** 0,0,w,h */
	protected static Rectangle2D field;
	/** 18,18,w-36,h-36 */
	protected static Rectangle2D battlefield;
	
	public void run() {}  //run once a round
	public void execute() {} //run once every tick
	public void onBulletHit(BulletHitEvent e) {}
	public void onBulletHitBullet(BulletHitBulletEvent e) {}
	public void onBulletMissed(BulletMissedEvent e) {}
	public void onHitByBullet(HitByBulletEvent e) {}
	public void onHitRobot(HitRobotEvent e) {}
	public void onHitWall(HitWallEvent e) {}
	public void onRobotDeath(RobotDeathEvent e) {}
	public void onScannedRobot(ScannedRobotEvent e) {}
	public void onStatus(StatusEvent e) {}
	public void onPaint(Graphics2D g) {}
	public void onRoundEnd() {}
	public void onBattleEnded(BattleEndedEvent e) {}
	
	public static final double getWallDistance(Point2D src, double heading, double dist, int direction) {
		double increment = Math.PI/64.0 * direction;
		Point2D next = null;
		int counter = -1;
		do {
			heading += increment;
			next = Tools.project(src, heading, dist);
			++counter;
		} while(battlefield.contains(next) && counter < 32); //There is a limit...
		return counter * Math.PI/64.0;
	}
}
