package lucasslf.wavesurfing.buffer;

import lucasslf.wavesurfing.EnemyWave;
import lucasslf.wavesurfing.BasicWaveSurfer;


public class SurfBufferT extends SurfBuffer {

	
	
	
	
	public SurfBufferT(int weight) {
		super(weight);
	}



	private static double[][][][][][] surfStats = new double[BasicWaveSurfer.SEG_MOVE_TIMES][BasicWaveSurfer.SEG_WALL_PROXIMITY][BasicWaveSurfer.SEG_VELOCITY][BasicWaveSurfer.SEG_VELOCITY][BasicWaveSurfer.SEG_DISTANCE][BasicWaveSurfer.BINS];
	
	
	
	public void setSegmentationOn(EnemyWave wave){
		wave.addSegmentedBuffer(getSegmentedBuffer(wave.getSegMoveTimes(),wave.getSegWallProximity(),wave.getSegMyVelocityBefore(),wave.getSegMyVelocity(),wave.getSegInitialDistance()));
	}
	
	@Override
	public SegmentedBuffer getSegmentedBuffer(int... args) {
		if(args == null || args.length != 5)
			throw new IllegalArgumentException("args length must be 5");
		return new SegmentedBuffer(surfStats[args[0]][args[1]][args[2]][args[3]][args[4]], this.getWeight());
	}

}
