package kinsen.melee.Movement;
import kinsen.melee.Angsaichmophobia;
import kinsen.melee.Bullet;
import kinsen.melee.Details;
import kinsen.melee.Utils;
import kinsen.melee.Guns.GunAvoidance;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/**
 * GridMovement - The main movement class for the robot--it uses a grid and chooses the best location
 */
public class GridMovement
{
	// Movement variables
	// Avoidance class that generates possible bullet locations
	private static GunAvoidance bulletAvoidance;
	// Debug: squares
	private ArrayList myLocations = new ArrayList();
	// Debug: Square that robot is going to
	private Rectangle2D.Double bestLocation = null;

	// Bullets that have been fired by enemies (assumes head-on)
	private ArrayList enemyBullets;
	// Type of bullets that have been fired
	private ArrayList enemyBulletTypes = new ArrayList();
	// Distance of closest bullets
	private ArrayList enemyBulletDistance;

	// Robot data
	private Details enemy = null;
	private Details me = null;
	private long time = -1;
	private Angsaichmophobia myRobot = null;

	// Constants
	// Number of squares to consider when moving
	// Must be positive odd number ^ 2
	private static final int NUMBER_MOVEMENT_SQUARES = 25;
	// Robot size for grid movement
	private static final int ROBOT_SIZE = 60;

	public void setVariables(Angsaichmophobia robot, ArrayList bullets, ArrayList bulletTypes, ArrayList bulletDistances, GunAvoidance newBulletAvoidance)
	{
		myRobot = robot;
		enemyBullets = bullets;
		enemyBulletTypes = bulletTypes;
		enemyBulletDistance = bulletDistances;
		bulletAvoidance = newBulletAvoidance;
	}

	/*
	 * newRound: Resets certain data
	 */
	public void newRound()
	{
		myLocations = new ArrayList();
		bestLocation = null;
	}

	public void recordData(Details enemyDetails, Details myDetails, long currentTime)
	{
		enemy = enemyDetails;
		me = myDetails;
		time = currentTime;

		bulletAvoidance.recordData(enemyDetails, myDetails, currentTime);
	}

	/*
	 * calculateMovement: Calculates distance and turn amount that robot should do
	 */
	public void calculateMovement()
	{
		if (me == null)
			return;

		// Check if bullets are still alive
		// If bullet is alive check if it will hit robot

		// Generate robot location as rectangle
		double myX = me.getX();
		double myY = me.getY();

		double myHeading = me.getHeading();

		removeInactiveBullets();

		// Creates 9 squares that robot can go to and chooses squre with least bullets
		// Best square location and score
		double leastBullets = -1;
		double bestX = -1, bestY = -1;
		// Enemy path
		double newEnemyX = 0;
		double newEnemyY = 0;
		if (enemy != null)
		{
			// Generate next enemy position
			newEnemyX = enemy.getX() + Math.sin(Math.toRadians(enemy.getHeading())) * enemy.getVelocity() * 12;
			newEnemyY = enemy.getY() + Math.cos(Math.toRadians(enemy.getHeading())) * enemy.getVelocity() * 12;
		}
		Point2D.Double newEnemyPosition = new Point2D.Double(newEnemyX, newEnemyY);
		Line2D.Double enemyPathLine;
		if (enemy != null)
			enemyPathLine = new Line2D.Double(new Point2D.Double(enemy.getX(), enemy.getY()), newEnemyPosition);
		else
			enemyPathLine = new Line2D.Double(new Point2D.Double(0, 0), new Point2D.Double(0, 0));
		GeneralPath enemyPath = new GeneralPath(enemyPathLine);

		// Debug line: Clears position rectangles
		myLocations.clear();

		// Large square side length
		int squareLength = (int) Math.sqrt(NUMBER_MOVEMENT_SQUARES);
		// Squares in one row halved
		int halvedSquareCount = (int) ((squareLength - 1) / 2);

		// Bullet weighting
		double bulletWeights[] = bulletAvoidance.getWeights();

		// Create bullet paths and endpoints
		ArrayList bulletPaths = new ArrayList();
		ArrayList bulletEndPoints = new ArrayList();
		for (int i = 0; i < enemyBullets.size(); i++)
		{
			Bullet currentBullet = (Bullet) enemyBullets.get(i);
			// Generate bullet path for several ticks
			Point2D.Double bulletPoint0 = new Point2D.Double((int) currentBullet.getCurrentX(time), (int) currentBullet.getCurrentY(time));
			Point2D.Double bulletPoint1 = new Point2D.Double((int) currentBullet.getCurrentX(time + 30), (int) currentBullet.getCurrentY(time + 30));
			Line2D.Double bulletPathLine = new Line2D.Double(bulletPoint0, bulletPoint1);
			bulletPaths.add(bulletPathLine);
			bulletEndPoints.add(bulletPoint1);
		}

		double centerX = myX;
		double centerY = myY;

		for (int i = 0; i < NUMBER_MOVEMENT_SQUARES; i++)
		{
			double bulletAmount = 0;
			// Current location is middle
			// Generate rectangle for current location
			double myNewX = centerX + ROBOT_SIZE * (i % squareLength - halvedSquareCount);
			double myNewY = centerY + ROBOT_SIZE * ((i - i % squareLength) / squareLength - halvedSquareCount);
			Rectangle2D.Double robotLocation = new Rectangle2D.Double((myNewX - ROBOT_SIZE / 2), (myNewY - ROBOT_SIZE / 2), ROBOT_SIZE, ROBOT_SIZE);
			myLocations.add(robotLocation);

			if (Utils.outOfBounds(myNewX - ROBOT_SIZE, myNewY - ROBOT_SIZE) || Utils.outOfBounds(myNewX + ROBOT_SIZE, myNewY - ROBOT_SIZE) ||
				Utils.outOfBounds(myNewX - ROBOT_SIZE, myNewY + ROBOT_SIZE) || Utils.outOfBounds(myNewX + ROBOT_SIZE, myNewY + ROBOT_SIZE))
			{
				bulletAmount = Integer.MAX_VALUE;
				// Debug
				myLocations.remove(myLocations.size() - 1);
			}
			else
			{
				Line2D.Double myPath = new Line2D.Double(myX, myY, myNewX, myNewY);
				for (int j = 0; j < Math.min(enemyBullets.size(), 50); j++)
				{
					Bullet currentBullet = (Bullet) enemyBullets.get(j);
					Line2D.Double bulletPath = (Line2D.Double) bulletPaths.get(j);
					Point2D.Double bulletEndPoint = (Point2D.Double) bulletEndPoints.get(j);

					// Check if bullet will hit next position
					if (bulletPath.intersects(robotLocation) || bulletPath.intersectsLine(myPath))
						bulletAmount += (currentBullet.getFirePower() + Utils.distance(myNewX, myNewY, bulletEndPoint.getX(), bulletEndPoint.getY()) / 50) *
										bulletWeights[((Integer) enemyBulletTypes.get(j)).intValue()];
				}

				// Check if robot will hit enemy
				if (enemyPath.intersects(robotLocation))
					bulletAmount = Integer.MAX_VALUE;
				else
					// Do not go too close to the enemy
					bulletAmount += Math.max(250 - Utils.distance(myNewX, myNewY, newEnemyX, newEnemyY), 0) * 10;
			}

			// Check if this is the currently best square
			boolean useLocation = bestX == -1 || (bulletAmount == 0 && i == (NUMBER_MOVEMENT_SQUARES - 1) / 2) || bulletAmount < leastBullets;
			if (useLocation)
			{
				leastBullets = bulletAmount;
				bestX = myNewX;
				bestY = myNewY;
				// Debug
				bestLocation = robotLocation;
			}
		}

		// Amount to move forward and amount to turn
		double travelDistance = travelDistance = Utils.distance(myX, myY, bestX, bestY);
		double myTurn = Utils.normalAbsoluteAngle(Utils.angleFromPoint(myX, myY, bestX, bestY) - myHeading);

		// Check if more efficient to go backwards
		if (myTurn > 90 && myTurn < 270 && travelDistance != 0)
		{
			myTurn -= 180;
			travelDistance *= -1;
		}

		myTurn = Utils.normalRelativeAngle(myTurn);
		travelDistance *= 100;

		myRobot.move(travelDistance, (int) (travelDistance / Math.abs(travelDistance)), myTurn, false);
	}

	/*
	 * removeInactiveBullets: Removes bullets fired by the enemy that are no longer active
	 */
	private void removeInactiveBullets()
	{
		double myX = me.getX();
		double myY = me.getY();

		enemyBulletDistance.clear();

		// Remove all inactive bullets and record distances for active bullets
		int i = 0;
		while (i < enemyBullets.size() && i < 10)
		{
			// Check if bullet is going farther away
			Bullet currentBullet = (Bullet) enemyBullets.get(i);
			double bulletX0 = currentBullet.getCurrentX(time);
			double bulletY0 = currentBullet.getCurrentY(time);
			double bulletX1 = currentBullet.getCurrentX(time + 1);
			double bulletY1 = currentBullet.getCurrentY(time + 1);
			double currentDistance = Utils.distance(myX, myY, bulletX0, bulletY0);
			if (currentDistance < Utils.distance(myX, myY, bulletX1, bulletY1) && currentDistance > 40)
			{
				enemyBullets.remove(i);
				enemyBulletTypes.remove(i);
			}
			else
			{
				i++;
				enemyBulletDistance.add(new Double(currentDistance));
			}
		}
	}

	public void debug(Graphics2D g)
	{
		// Show possible rectangles to move to
		g.setColor(Color.white);
		for (int i = 0; i < myLocations.size(); i++)
		{
			Rectangle2D.Double location = (Rectangle2D.Double) myLocations.get(i);
			g.drawRect((int) location.getX(), (int) location.getY(), (int) location.getWidth(), (int) location.getHeight());
		}
		// Show best rectangle
		g.setColor(Color.red);
		if (bestLocation != null)
		{
			g.drawRect((int) bestLocation.getX(), (int) bestLocation.getY(), (int) bestLocation.getWidth(), (int) bestLocation.getHeight());
		}
	}
}