package nat.ether.stats;

import nat.ether.utils.*;

public class StatsManager {
	public static final int BINS = 77;
	
	float[] stats = new float[BINS];
	
	public StatsManager() {
		registerHit(null, 0d);
	}
	
	public float[] getStatsBin(Store scan) {
		return stats;
	}
	
	public void registerHit(Store scan, double GF) {
		BinUtils.makeSmoothedBins(this.stats, new Range(GF, GF), 1f);
		
		float max = 0;
		for (int i = 0; i < BINS; i++) {
			max = Math.max(max, this.stats[i]);
		}
		for (int i = 0; i < BINS; i++) {
			this.stats[i] /= max;
		}
	}
}
