package pez.rumble.pgun;
import pez.rumble.pmove.Butterfly;
import pez.rumble.utils.*;
import robocode.*;
import robocode.util.Utils;
import java.util.*;
import java.awt.geom.*;

//BumbleBee, a gun by PEZ. For CassiusClay - Sting like a bee! Even if it is a bumble-bee this time... =)
//An attempt to do GF targeting with fuzzy segmentation macthes, using a log of all collected waves.
//http://robowiki.net/?Ali/BumbleBee
//
//This code is released under the RoboWiki Public Code Licence (RWPCL), datailed on:
//http://robowiki.net/?RWPCL
//(Basically it means you must keep the code public if you base any bot on it.)
//
//$Id: BumbleBee.java,v 1.11 2006/05/10 05:43:33 peter Exp $

public class BumbleBee {
	public static boolean isTC = false; // TargetingChallenge
	public static boolean doGL = false;
	
	static final double MAX_VELOCITY = 8.0;
	static final double MAX_BULLET_POWER = 3.0;
	static final double WALL_MARGIN = 18;
	static final double MAX_DISTANCE = 900;
	static final double BULLET_POWER = 1.91;
	
	static Point2D enemyLocation = new Point2D.Double();
	static double distance;
	static double lastVelocity;
	static int timeSinceVChange;
	static int timeSinceFire;
	static double lastBearingDirection = 0.73;
	static int tick;
	static long lastScanTime;

	static double roundNum;
	
	Rectangle2D fieldRectangle;
	AdvancedRobot robot;
	RobotPredictor robotPredictor;
	BumbleWave lastWave = null;
	boolean isAiming;
	
	public BumbleBee(AdvancedRobot robot, RobotPredictor robotPredictor) {
		this.robot = robot;
		BumbleWave.init();
		this.robotPredictor = robotPredictor;
		fieldRectangle = PUtils.fieldRectangle(robot, WALL_MARGIN);
		roundNum++;
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if (robot.getTime() != lastScanTime) {
			lastScanTime = robot.getTime();
			BumbleWave wave = new BumbleWave(robot);
			wave.logEntry.birthTick = tick++;
			wave.setStartTime(robot.getTime());
			boolean shouldFire = shouldFire(e);
			if (robot.getOthers() > 0) {
				BumbleWave.waves.add(wave);
			}
			
			distance = e.getDistance();
			wave.logEntry.fireDistance = 100 * Math.min(distance, MAX_DISTANCE) / MAX_DISTANCE;
			
			double wantedBulletPower = isTC ? MAX_BULLET_POWER : distance > 140 ? BULLET_POWER : MAX_BULLET_POWER;
			double bulletPower = wantedBulletPower;
			if (!isTC) {
				bulletPower = Math.min(Math.min(e.getEnergy() / 4, robot.getEnergy() / (distance > 140 ? 7 : 2)), wantedBulletPower);
			}
			Point2D robotLocation = new Point2D.Double(robot.getX(), robot.getY());
			wave.setGunLocation(robotLocation);
			double bearing = robot.getHeadingRadians() + e.getBearingRadians();
			wave.setStartBearing(bearing);
			wave.setTargetLocation(enemyLocation);
			enemyLocation.setLocation(PUtils.project(robotLocation, bearing, distance));
			
			wave.logEntry.velocity = 75 * Math.abs(e.getVelocity()) / MAX_VELOCITY;
			double vDiff = e.getVelocity() - lastVelocity;
			wave.logEntry.accel = 37.5;
			
			if (Math.abs(vDiff) > 0.1) {
				timeSinceVChange = 0;
				if (vDiff < 0.1) {
					wave.logEntry.accel = 1;
				}
				else {
					wave.logEntry.accel = 75;
				}
			}
			lastVelocity = e.getVelocity();

			double bulletVelocity = PUtils.bulletVelocity(bulletPower);
			wave.setBulletVelocity(bulletVelocity);
			
			double lateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - bearing);
			if (e.getVelocity() != 0) {
				lastBearingDirection = wave.maxEscapeAngle() * PUtils.sign(lateralVelocity);
			}
			double orbitDirection = lastBearingDirection / (double)BumbleWave.MIDDLE_FACTOR;
			wave.setOrbitDirection(orbitDirection);

			wave.logEntry.approachAngle = 37 * PUtils.sign(e.getVelocity()) * Math.cos(e.getHeadingRadians() - bearing);
			//wave.logEntry.wallDistance = Math.min(75, Math.pow(wave.wallDistance(1, fieldRectangle) * 7, 2));
			//wave.logEntry.reverseWallDistance = Math.min(75, Math.pow(wave.wallDistance(-1, fieldRectangle) * 5, 2));
			//wave.logEntry.velocityChangedTimer = Math.min(75, Math.pow(timeSinceVChange * 0.5, 2));
			//wave.logEntry.lastVelocityChangedTimer = Math.min(75, Math.pow(lastTimeSinceVChange * 0.5, 2));
			wave.logEntry.wallDistance = Math.min(75, wave.wallDistance(1, fieldRectangle) * 60);
			wave.logEntry.reverseWallDistance = Math.min(75, wave.wallDistance(-1, fieldRectangle) * 60);
			wave.logEntry.velocityChangedTimer = Math.min(75, timeSinceVChange);
			wave.logEntry.myWallDistance = Math.min(75, (Butterfly.wallDistance * 60));
			timeSinceVChange++;
			timeSinceFire++;
			BumbleWave.updateWaves();
			
			Point2D nextRobotLocation = robotPredictor.getNextLocation(robot);
			Point2D nextEnemyLocation = PUtils.project(enemyLocation, e.getHeadingRadians(), e.getVelocity());
			double guessedBearing = PUtils.absoluteBearing(nextRobotLocation, nextEnemyLocation);
			if (lastWave != null) {
 				lastWave.setStartBearing(PUtils.absoluteBearing(robotLocation, enemyLocation));
 				lastWave.setGunLocation(robotLocation);
 			}
			if (robot.getGunHeat() > robot.getGunCoolingRate() * 2) {
				isAiming = false;
			}
			else {
				if (isAiming && shouldFire) {
					robot.setFire(bulletPower);
					isAiming = false;
					timeSinceFire = 0;
				}
				else {
					guessedBearing += orbitDirection * (wave.mostVisited() - BumbleWave.MIDDLE_FACTOR);
					robot.setTurnGunRightRadians(Utils.normalRelativeAngle(guessedBearing - robot.getGunHeadingRadians()));
					if (robot.getGunHeat() <= robot.getGunCoolingRate()) {
						isAiming = true;
					}
				}
			}
			lastWave = wave;
		}
	}
	
	boolean shouldFire(ScannedRobotEvent e) {
		return (isTC || (robot.getEnergy() >= BULLET_POWER && Math.abs(robot.getGunTurnRemainingRadians()) < PUtils.botWidthAngle(e.getDistance()) / 2 || e.getDistance() < 150));
	}
	
	public void onBulletHit(BulletHitEvent e) {
		BumbleWave.hits++;
		if (e.getBullet().getPower() > 1.2 && distance > 150) {
			BumbleWave.rangeHits++;
		}
	}
	
	public void roundOver() {
		System.out.println("range hits given: " + (int)BumbleWave.rangeHits + " (average / round: " + PUtils.formatNumber(BumbleWave.rangeHits / roundNum) + ")");
		BumbleWave.cleanLog();
		System.out.println("log size: " + BumbleWave.log.size());
	}
}

class BumbleWave extends Wave {
	static final double WALL_INDEX_WIDTH = 3;
	static final int FACTORS = 33;
	static final int MIDDLE_FACTOR = (FACTORS - 1) / 2;
	static final int LOG_SIZE = 40000;
	static final double MATCH_THRESHOLD = 6000;
	static final int MAX_MATCHES = 10000;
	static final int CLUSTER_SIZE = 100;
	
	static List waves;
	static double hits;
	static double rangeHits;
	static List log = new ArrayList();
	
	LogEntry logEntry = new LogEntry();
	
	static void init() {
		waves = new ArrayList();
	}
	
	public BumbleWave(AdvancedRobot robot) {
		init(robot, FACTORS);
	}
	
	static void updateWaves() {
		List reap = new ArrayList();
		for (int i = 0, n = waves.size(); i < n; i++) {
			BumbleWave wave = (BumbleWave)waves.get(i);
			wave.setDistanceFromGun((robot.getTime() - wave.getStartTime()) * wave.getBulletVelocity());
			if (wave.passed(18)) {
				if (wave.getRobot().getOthers() > 0) {
					wave.registerVisits();
				}
				reap.add(wave);
			}
		}
		for (int i = 0, n = reap.size(); i < n; i++) {
			waves.remove(reap.get(i));
		}
	}
	
	void registerVisits() {
		logEntry.visitIndex = Math.max(1, visitingIndex());
		log.add(logEntry);
	}
	
	int mostVisited() {
		List coarse = matchesPhase1(log, logEntry);
		Collections.sort(coarse);
		List matches = coarse.subList(0, Math.min(Math.max(0, coarse.size() - 1), CLUSTER_SIZE));
		return mostVisitedIndex(matches);
	}

//	public double maxEscapeAngle() {
//		return PUtils.maxEscapeAngle(bulletVelocity) * 1.4;
//	}

	static List matchesPhase1(List log, LogEntry currentEntry) {
		List matches = new ArrayList();
		double matchThreshold = MATCH_THRESHOLD + (double)LOG_SIZE / (double)log.size();
//double totDistance = 0;
		for (int i = log.size() - 1, matchedEntries = 0; matchedEntries < MAX_MATCHES && i >= 0; i--) {
			LogEntry e = (LogEntry)log.get(i);
			double distance = e.distanceSq(currentEntry);
//totDistance += distance;
			if (distance < matchThreshold) {
				Factor f = new Factor(e);
				f.distance = distance; //e.distanceEuclidian(currentEntry);
				matches.add(f);
				matchedEntries++;
			}
		}
//System.out.println(totDistance / (double)log.size());
		return matches;
	}
	
	static int mostVisitedIndex(List matches) {
		int[] factors = new int[FACTORS];
		for (int i = 0, n = matches.size(); i < n; i++) {
			Factor f = (Factor)matches.get(i);
			f.entry.uses++;
			factors[f.entry.visitIndex]++;
		}
		int mostVisitedIndex = MIDDLE_FACTOR;
		int most = 0;
		for (int i = 1; i < FACTORS; i++) {
			if (factors[i] > most) {
				mostVisitedIndex = i;
				most = factors[i];
			}
		}
		return mostVisitedIndex;
	}
	
	static double hitRate() {
		return rangeHits / (BumbleBee.roundNum + 1);
	}
	
	static void cleanLog() {
		if (log.size() > (int)(LOG_SIZE * 1.5)) {
			Collections.sort(log, LogEntry.USAGE_COMPARATOR);
			log.subList(LOG_SIZE - 1, log.size() - 1).clear();
		}
	}
}

class LogEntry {
	static final UsageComparator USAGE_COMPARATOR = new UsageComparator();
	static final AgeComparator AGE_COMPARATOR = new AgeComparator();
	double fireDistance;
	double velocity;
	double accel;
	double velocityChangedTimer;
	double wallDistance;
	double reverseWallDistance;
	double approachAngle;
	double myWallDistance;
	int visitIndex;
	int birthTick;
	int uses;
	
	double distanceSq(LogEntry e) {
		double distance = 0;
		distance += 4 * sqr(this.fireDistance - e.fireDistance);
		distance += sqr(this.velocity - e.velocity);
		distance += sqr(this.accel - e.accel);
		distance += sqr(this.velocityChangedTimer - e.velocityChangedTimer);
		distance += 4 * sqr(this.wallDistance - e.wallDistance);
		distance += sqr(this.reverseWallDistance - e.reverseWallDistance);
		distance += sqr(this.approachAngle - e.approachAngle);
		distance += sqr(this.myWallDistance - e.myWallDistance);
		return distance;
	}
	
	double usage() {
		if (age() < BumbleWave.LOG_SIZE / 10.0) {
			return 100;
		}
		return (uses * BumbleWave.LOG_SIZE) / age();
	}
	
	double age() {
		return BumbleBee.tick - this.birthTick;
	}
	
	static double sqr(double v) {
		return v * v;
	}
	
	static class UsageComparator implements Comparator {
		public int compare(Object a, Object b) {
			return PUtils.sign(((LogEntry)b).usage() - ((LogEntry)a).usage());
		}
	}
	
	static class AgeComparator implements Comparator {
		public int compare(Object a, Object b) {
			return (int)(((LogEntry)b).age() - ((LogEntry)a).age());
		}
	}

	public String toString() {
		return "d: " + fireDistance + ", v: " + velocity + ", a: " + accel + ", vct: " + velocityChangedTimer + ", wd: " + wallDistance + ", rwd: " + reverseWallDistance + ", app: " + approachAngle;
	}
}

class Factor implements Comparable  {
	LogEntry entry;
	double distance;
	
	private Factor() {};
	
	Factor(LogEntry _entry) {
		this.entry = _entry;
	}
	
	public int compareTo(Object o) {
		double compareDistance = ((Factor)o).distance;
		if (distance > compareDistance) {
			return 1;
		}
		else if (distance < compareDistance) {
			return -1;
		}
		return 0;
	}
}