package qwaker00;

import java.io.Serializable;

class GFHolder implements Serializable {
    double[] hits = new double[41];
    final double HISTORY = 50.;

    public int length() {
        return hits.length;
    }

    public void Hit(int gfIndex) {
        hits[gfIndex] = (hits[gfIndex] * HISTORY + 1.) / (HISTORY + 1);
        for (int i = 0; i < hits.length; ++i) if (i != gfIndex) {
            hits[i] = hits[i] * HISTORY / (HISTORY + 1);
        }
    }

    public double getAngle(double maxAngleFront, double maxAngleBack) {
        int halfL = length() / 2;
        int gf = Predict();

        double result;
        if (gf >= halfL)
            result = (gf - halfL) * maxAngleFront / halfL;
        else
            result = (gf - halfL) * maxAngleBack / halfL;

        //System.out.println("GetAngle: " + gf + " " + maxAngleFront + " " + maxAngleBack + " = " + result);
        return result;
    }

    public int Predict() {
        int gfMax = hits.length / 2;

        double maxCost = 0;
        for (int i = 0; i < hits.length; ++i) {
            double cost = 0;
            double d1 = i, d2 = hits.length - 1 - i;

            for (int j = 0; j < hits.length; ++j) {
                if (j < i)
                    cost += hits[j] * 1. / (d1 * 2 * Math.PI) * Math.exp(-(j - i)*(j - i) / (2 * d1 * d1));
                else if (j > i)
                    cost += hits[j] * 1. / (d2 * 2 * Math.PI) * Math.exp(-(j - i)*(j - i) / (2 * d2 * d2));
                else
                    cost += hits[j] * 1. / (Math.max(d1, d2) * 2 * Math.PI);
        //        cost += hits[j] * 1. / (d * 2 * Math.PI) * Math.exp(-(j - i)*(j - i) / (2 * d * d));
            }

            if (cost > maxCost) {
                gfMax = i;
                maxCost = cost;
            }
        }

        return gfMax;
    }
}
